/***************************************************************************
    begin                : Thu Apr 24 2003
    copyright            : (C) 2003 by Christian Hubinger
    email                : chubinger@irrsinnig.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kmfobjectinfo.h"

// KDE Includes
#include <kdebug.h>
#include <kapplication.h>
#include <klocale.h>

// QT includes
#include <tqstring.h>
#include <tqlabel.h>
#include <tqpushbutton.h>
#include <tqtextedit.h>

// Project includes
#include "../core/iptrule.h"
#include "../core/iptchain.h"
#include "../core/iptable.h"
#include "../core/kmfdoc.h"
#include "../core/kmfiptdoc.h"
#include "../core/kmfnetwork.h"
#include "../core/kmfundoengine.h"
namespace KMF {
KMFObjectInfo::KMFObjectInfo(TQWidget *parent, const char *name, bool modal ) : KMyFirewallObjectInfo(parent, name, modal) {
}

KMFObjectInfo::~KMFObjectInfo(){
}

void KMFObjectInfo::loadNetfilterObject( NetfilterObject* obj ) {
	if ( ! obj )
		return;
	m_netfilter_object = obj;
	m_doc = 0;
	switch( m_netfilter_object->type() ) {
		case NetfilterObject::RULE:
			m_header->setText( i18n("Rule Documentation") );
			break;
		case NetfilterObject::CHAIN:
			m_header->setText( i18n("Chain Documentation") );
			break;
		default:
			m_header->setText( i18n("Object Documentation") );
			break;
	}
	te_desc->setText( m_netfilter_object->description() );
}

void KMFObjectInfo::loadKMFDoc( KMFDoc* obj ){
	if ( ! obj )
		return;
	m_doc = obj;
	m_netfilter_object = 0;
	m_header->setText( i18n("Firewall Documentation") );
	te_desc->setText( m_doc->description() );
}

void KMFObjectInfo::accept() {
	if ( m_netfilter_object ) {
		if ( m_netfilter_object->description() != te_desc->text() ) {
			KMFUndoEngine::instance()->startTransaction(
				m_netfilter_object,
				i18n("Edit Documentaion for: %1").arg( m_netfilter_object->name() ) 
			);
			m_netfilter_object->setDescription( te_desc->text() );
			kdDebug()  << "Description Changed: " << te_desc->text() <<  endl;
			KMFUndoEngine::instance()->endTransaction();
		}
	} else if ( m_doc ) {
		if ( m_doc->description() != te_desc->text() ) {
			KMFUndoEngine::instance()->startTransaction(
				m_doc, 
				i18n("Edit Documentaion for: %1").arg( m_netfilter_object->name() ) 
			);
			m_doc->setDescription( te_desc->text() );
			KMFUndoEngine::instance()->endTransaction();
			kdDebug()  << "Description Changed: " << te_desc->text() <<  endl;
		}
	}
	
	emit sigDocumentChanged();
	emit sigHideMe();
}

void KMFObjectInfo::reject() {
	emit sigHideMe();
}

void KMFObjectInfo::slotHelp() {
	kapp->invokeHelp( "rule_documentation" );
}

}

#include "kmfobjectinfo.moc"

