//
// C++ Implementation: kmfnetworkwidget
//
// Description:
//
//
// Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kmfnetworkwidget.h"

// QT includes
#include <tqlabel.h>
#include <tqtextedit.h>
#include <tqevent.h>

// KDE includes
#include <kdebug.h>
#include <knuminput.h>
#include <klocale.h>

// project includes
#include "../core/kmfundoengine.h"


namespace KMF {
KMFNetworkWidget::KMFNetworkWidget(TQWidget *parent, const char *name)
		: KMyFirewallNetworkWidget(parent, name) {
	m_allowEdit = true;
	connect( m_sb_from_1,TQT_SIGNAL( valueChanged( const TQString& ) ),
		this,TQT_SLOT( slotAddressChanged( const TQString& ) ) );
	connect( m_sb_from_2,TQT_SIGNAL( valueChanged( const TQString& ) ),
		this,TQT_SLOT( slotAddressChanged( const TQString& ) ) );
	connect( m_sb_from_3,TQT_SIGNAL( valueChanged( const TQString& ) ),
		this,TQT_SLOT( slotAddressChanged( const TQString& ) ) );
	connect( m_sb_from_4,TQT_SIGNAL( valueChanged( const TQString& ) ),
		this,TQT_SLOT( slotAddressChanged( const TQString& ) ) );
	
	connect( m_sb_mask,TQT_SIGNAL( valueChanged( int ) ),
		this,TQT_SLOT( slotShortMaskChanged( int ) ) );
		
	connect( m_txt_desc,TQT_SIGNAL( textChanged() ),
		this,TQT_SLOT( slotDescriptionChanged() ) );

}


KMFNetworkWidget::~KMFNetworkWidget() {}

void KMFNetworkWidget::slotZoneDeleted() {
	setEnabled( false );
}

void KMFNetworkWidget::loadZone( KMFNetZone* zone ) {
	setEnabled( true );
	blockAllSignals( true );	
	m_zone = zone;
	connect( m_zone, TQT_SIGNAL( destroyed() ), this, TQT_SLOT ( slotZoneDeleted() ) );
	
	m_sb_from_1->setEnabled( true );
	m_sb_from_2->setEnabled( true );
	m_sb_from_3->setEnabled( true );
	m_sb_from_4->setEnabled( true );
	m_sb_mask->setEnabled( true );
	
	m_sb_from_1->setValue( zone->address()->getDigit( 0 ) );
	m_sb_from_2->setValue( zone->address()->getDigit( 1 ) );
	m_sb_from_3->setValue( zone->address()->getDigit( 2 ) );
	m_sb_from_4->setValue( zone->address()->getDigit( 3 ) );

	lbl_mask->setText( zone->mask()->toString() );
	if ( zone->description() != m_txt_desc->text().simplifyWhiteSpace() ) {
		m_txt_desc->setText( zone->description() );
	}
	m_sb_mask->setValue( IPAddress::calcLenthToMask( *zone->mask() ) );
	blockAllSignals( false );	
}

void KMFNetworkWidget::slotAddressChanged( const TQString& ) {
	kdDebug() << "void KMFNetworkWidget::slotAddressChanged( const TQString& )" << endl;
	if ( ! m_zone ) {
		return;
	}
	
	blockAllSignals( true );
	if ( m_allowEdit ) {
		
		const TQString& newAddr =	m_sb_from_1->text() +"."+ 
									m_sb_from_2->text() +"."+
									m_sb_from_3->text() +"."+
									m_sb_from_4->text();
									
		if ( newAddr == m_zone->address()->toString() ) {
			return;
		}
		KMFUndoEngine::instance()->startTransaction(
			m_zone->rootZone(),
			i18n( "Change address of Zone: %1" ).arg( m_zone->guiName() )
		);
		
		m_zone->address()->setAddress( m_sb_from_1->value(), m_sb_from_2->value(), m_sb_from_3->value(), m_sb_from_4->value() );
		m_zone->rootZone()->refreshNetworkTree();
		KMFUndoEngine::instance()->endTransaction();
		emit sigZoneChanged( m_zone );
	}
	blockAllSignals( false );
	
}

void KMFNetworkWidget::slotShortMaskChanged( int len ) {
	kdDebug() << "void KMFNetworkWidget::slotShortMaskChanged( const TQString& )" << endl;
	IPAddress addr = IPAddress::calcNetworkMaskFromLength( len );
	blockAllSignals( true );
	lbl_mask->setText( addr.toString() );
	if ( m_allowEdit && m_zone->maskLength() != len ) {
		KMFUndoEngine::instance()->startTransaction(
			m_zone->rootZone(),
			i18n( "Change mask length of Zone: %1" ).arg( m_zone->guiName() )
		);
		m_zone->setMaskLength( len );
		m_zone->rootZone()->refreshNetworkTree();
		KMFUndoEngine::instance()->endTransaction();
		emit sigZoneChanged( m_zone );
	}
	blockAllSignals( false );
}

void KMFNetworkWidget::slotDescriptionChanged() {
	kdDebug() << "void KMFNetworkWidget::slotDescriptionChanged( const TQString& )" << endl;
	if ( ! m_zone ) {
		return;
	}
	TQString newTxt = m_txt_desc->text().simplifyWhiteSpace();
	if ( m_allowEdit && newTxt != m_zone->description() ) {
		blockAllSignals( true );
		KMFUndoEngine::instance()->startTransaction(
			m_zone,
			i18n( "Change documentation of Zone: %1" ).arg( m_zone->guiName() )
		);
		m_zone->setDescription( newTxt );
		KMFUndoEngine::instance()->endTransaction();
		emit sigZoneChanged( m_zone );
		blockAllSignals( false );
	}
}

void KMFNetworkWidget::focusOutEvent( TQFocusEvent * e ) {
    kdDebug() << "void KMFNetworkWidget::focusOutEvent( TQFocusEvent * e )" << endl;
    if ( e->lostFocus() && m_txt_desc->text().simplifyWhiteSpace() != m_zone->description() ) {
    	slotDescriptionChanged();
    }
}

void KMFNetworkWidget::blockAllSignals( bool onOff ) {
	m_sb_from_1->blockSignals( onOff );
	m_sb_from_2->blockSignals( onOff );
	m_sb_from_3->blockSignals( onOff );
	m_sb_from_4->blockSignals( onOff );
	m_txt_desc->blockSignals( onOff );
	m_sb_mask->blockSignals( onOff );
}	

void KMFNetworkWidget::allowEdit( bool allow ) {
	m_allowEdit = allow;
	m_sb_from_1->setEnabled( allow );
	m_sb_from_2->setEnabled( allow );
	m_sb_from_3->setEnabled( allow );
	m_sb_from_4->setEnabled( allow );
	m_txt_desc->setEnabled( allow );
	m_sb_mask->setEnabled( allow );
}

}




#include "kmfnetworkwidget.moc"
