/***************************************************************************
 begin                : Thu Feb 7  2002
 copyright            : (C) 2002 by Christian Hubinger
 email                : chubinger@irrsinnig.org
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KMFRULEEDIT_H
#define KMFRULEEDIT_H
#include "kmyfirewallruleeditor.h"

// qt includes
#include <tqvariant.h>
#include <tqdialog.h>
#include <tqpixmap.h>
#include <tqstring.h>
#include <tqvaluelist.h>
#include <tqguardedptr.h>

// kde includes
#include <kconfig.h>
#include <kiconloader.h>
#include <kstandarddirs.h> 

// project includes
#include "../core/kmfruleeditinterface.h"
class TQListViewItem;
class KListViewItem;
class TQString;
class KPopupMenu;

namespace KMF {
class KMFIPTDoc;
class KMFNetwork;
class KMFListView;
class KMFListViewItem;
class NetfilterObject;
class IPTRule;
class IPTChain;
class IPTable;
class KMFErrorHandler;
class KMFError;
class KMFCheckInput;
class KMFChainEdit;
class KMFNewChainDlg;
class KMFObjectInfo;
class KMFRuleOptionEditInterface;
class KMFRuleTargetOptionEditInterface;
class KMFMainWindow;
class KMFMyNetworkWidget;

class KMFRuleEdit : public KMyFirewallRuleEditor, public KMFRuleEditInterface {
	Q_OBJECT
  TQ_OBJECT

public:
	KMFRuleEdit( TQWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
	~KMFRuleEdit();
	IPTRule* currRule() const {
		return m_rule;
	};

	void loadDoc( KMFNetwork* network );
	void editChain( IPTChain* );
	void addRuleOption(TQString*, TQPtrList< TQString >* );
	void addRuleTargetOption(TQString*, TQPtrList< TQString >* ); 
	void showOverview(); 
	void setKMFMainWindow( KMFMainWindow* win );
		
public slots:
	void slotAddRule();
 	void slotEditRule();
	void slotDelRule();
	void slotAddChain();
	void slotDelChain();
	void slotEditChain();
	void slotEditNetwork();
	void slotLoadDocument( KMFNetwork* network );
	void slotUpdateView();
	void slotSelectionInvalid();

protected:
	bool event( TQEvent* );

private:
	// members
	void createRBM( NetfilterObject* );
	void loadIcons();
	void enableRuleEdit( bool on );
	KMFListView* currTableView();
	void setCurrTableView( KMFListView* );
	void loadPlugins();
	void registerRuleOptionPlugin( KMFRuleOptionEditInterface* );
	void registerRuleTargetOptionPlugin( KMFRuleTargetOptionEditInterface* );

	// data
	KMFIPTDoc *m_lastDisplayDoc;
	
	KMFMyNetworkWidget *m_myNetworkWidget;
	KMFObjectInfo *m_object_info;
	KMFChainEdit *m_editchain;
	KMFNewChainDlg *m_new_chain;
	KMFListView *m_lv_table_filter, *m_lv_table_nat, *m_lv_table_mangle;
	TQGuardedPtr<KMFNetwork> m_network;
	TQGuardedPtr<IPTRule> m_rule;
	TQGuardedPtr<IPTChain> m_chain;
	TQGuardedPtr<IPTable> m_table;
	
	
	TQPtrList<KMFRuleOptionEditInterface> m_editPlugins;
	TQPtrList<KMFRuleTargetOptionEditInterface> m_editTargetPlugins;
	
	KMFError *m_err;
	KMFErrorHandler *m_err_handler;
	KMFCheckInput *m_check_input;
	KMFMainWindow *m_app;
	KPopupMenu *m_contextMenu;
	TQPixmap icon_up, icon_down, icon_del, icon_edit, icon_rule, icon_filter, icon_rename,
	icon_chain, icon_log, icon_accept, icon_drop, icon_cmd, icon_reject, icon_return,
	        icon_target, icon_queue, icon_new, icon_copy, icon_move;


private slots:
	void slotNewItemSelected( TQListViewItem* );


	void slotRuleRBM( TQListViewItem*, const TQPoint &, int );
	void slotRenameRule();
	void slotRenameRule( TQListViewItem*, int, const TQString& );
	void slotNewOptionType( int index );
	void slotShowOverview();

	void slotEditRuleInfo();
	void slotEditChainInfo();
	void slotEditTargetOption();


	void slotFragChanged();
	void slotLogRuleChanged();
	void slotEnableRuleChanged();
	void slotTargetChanged( const TQString& );

	void slotNewTableSelected();

	void slotAddRuleOption( TQString*, TQPtrList<TQString>* );
	void slotAddTargetOption( TQString*, TQPtrList<TQString>* );

	void slotMoveRuleUp();
	void slotMoveRuleDown();
	void slotMoveRule( int );
	void slotCopyRule( int );

	void slotHelp();

private:
	void moveRuleInChain( int );

	signals:
	void sigFragToggled();
	void sigUpdateView();
	void sigUpdateView( NetfilterObject* );
};
}
#endif // KMFRULEEDIT_H
