//
//
// C++ Implementation: $MODULE$
//
// Description:
//
//
// Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2003
//
// Copyright: See COPYING file that comes with this distribution
//
//
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "kmfgenericinterfacenat.h"


// QT includes
#include <tqstring.h>
#include <tqstringlist.h>
#include <tqcheckbox.h>
#include <tqlistview.h>

// KDE includes
#include <kdebug.h>
#include <klocale.h>
#include <kcombobox.h>
#include <knuminput.h>
#include <klistview.h>

// Project includes
#include "../core/kmfnetwork.h"
#include "../core/kmftarget.h"
#include "../core/kmftargetconfig.h"
#include "../core/kmfgenericdoc.h"
#include "../core/kmfconfig.h"
namespace KMF {
KMFGenericInterfaceNat::KMFGenericInterfaceNat( TQWidget *parent, const char *name, WFlags f )
		: KMyFirewallGenericInterfaceNATWidget( parent, name, f ) {

connect( m_c_enable_nat, TQT_SIGNAL( toggled( bool ) ),
	this, TQT_SLOT( slotNatEnabled( bool ) ) );
connect( m_c_use_masquerade, TQT_SIGNAL( toggled( bool ) ),
	this, TQT_SLOT( slotMasqueradeEnabled( bool ) ) );


connect( m_sb_addr_1, TQT_SIGNAL( valueChanged( const TQString& ) ),
	this, TQT_SLOT( slotAddressChanged( const TQString& ) ) );
connect( m_sb_addr_2, TQT_SIGNAL( valueChanged( const TQString& ) ),
	this, TQT_SLOT( slotAddressChanged( const TQString& ) ) );
connect( m_sb_addr_3, TQT_SIGNAL( valueChanged( const TQString& ) ),
	this, TQT_SLOT( slotAddressChanged( const TQString& ) ) );
connect( m_sb_addr_4, TQT_SIGNAL( valueChanged( const TQString& ) ),
	this, TQT_SLOT( slotAddressChanged( const TQString& ) ) );

connect( m_cb_external_interface, TQT_SIGNAL(  activated( const TQString& ) ),
	this, TQT_SLOT( slotExternalInterfaceChanged( const TQString& ) ) );
}


KMFGenericInterfaceNat::~KMFGenericInterfaceNat() {}

void KMFGenericInterfaceNat::slotUpdateView( NetfilterObject* ) {
	kdDebug() << "KMFGenericInterfaceNat::slotUpdateView( NetfilterObject* )" << endl;
	if ( ! m_doc ) {
		kdDebug() << "WRINING: m_doc == 0" << endl;
		return;
	}
	slotUpdateView();
}
void KMFGenericInterfaceNat::slotUpdateView() {
	kdDebug() << "void KMFGenericInterfaceNat::slotUpdateView()" << endl;
	if ( ! m_doc ) {
		kdDebug() << "WRINING: m_doc == 0" << endl;
		return;
	}
	m_c_enable_nat->setChecked( m_doc->currentDocAsGenericDoc()->useNat() );
	m_c_use_masquerade->setChecked( m_doc->currentDocAsGenericDoc()->useMasquerade() );
// 	m_c_restrict_nat->setChecked( m_doc->restrictNat() );
	m_sb_addr_1->blockSignals( true );
	m_sb_addr_2->blockSignals( true );
	m_sb_addr_3->blockSignals( true );
	m_sb_addr_4->blockSignals( true );
	m_sb_addr_1->setValue( m_doc->currentDocAsGenericDoc()->natAddress()->getDigit( 0 ) );
	m_sb_addr_2->setValue( m_doc->currentDocAsGenericDoc()->natAddress()->getDigit( 1 ) );
	m_sb_addr_3->setValue( m_doc->currentDocAsGenericDoc()->natAddress()->getDigit( 2 ) );
	m_sb_addr_4->setValue( m_doc->currentDocAsGenericDoc()->natAddress()->getDigit( 3 ) );
	kdDebug() << "Setting Address Fields to: " << m_doc->currentDocAsGenericDoc()->natAddress()->getDigit( 0 ) << "." <<
					 m_doc->currentDocAsGenericDoc()->natAddress()->getDigit( 1 ) << "." << m_doc->currentDocAsGenericDoc()->natAddress()->getDigit( 2 ) << "." <<
					  m_doc->currentDocAsGenericDoc()->natAddress()->getDigit( 3 ) << endl;
	m_sb_addr_1->blockSignals( false );
	m_sb_addr_2->blockSignals( false );
	m_sb_addr_3->blockSignals( false );
	m_sb_addr_4->blockSignals( false );

	TQStringList interfaces =  m_doc->currentTarget()->config()->interfaces();
	m_cb_external_interface->clear();
	m_cb_external_interface->insertStringList( interfaces );

	TQString interf = m_doc->currentDocAsGenericDoc()->outgoingInterface();

	interf = m_doc->currentDocAsGenericDoc()->outgoingInterface();
	bool found = false;
	int i = 0;
	for ( TQStringList::Iterator it = interfaces.begin(); it != interfaces.end() && ! found; ++it ) {
		if ( *it == interf ) {
			m_cb_external_interface->setCurrentItem( i );
		}
		i++;
    }

}

/*!
    \fn KMFGenericInterfaceNat::loadDoc( KMFGenericDoc* )
 */
void KMFGenericInterfaceNat::loadDoc( KMFNetwork* doc ) {
	kdDebug() << "void KMFGenericInterfaceNat::loadDoc( KMFGenericDoc* )" << endl;
	m_doc = doc;
	slotUpdateView();
}


/*!
    \fn KMFGenericInterfaceNat::slotNatEnabled( bool )
 */
void KMFGenericInterfaceNat::slotNatEnabled( bool onoff ) {
	KMFUndoEngine::instance()->startTransaction(
		m_doc->currentDocAsGenericDoc(),
		i18n( "%1 NAT." ).arg( onoff ? i18n( "Enable" ) : i18n( "Disable" ) )
	);
	
	m_doc->currentDocAsGenericDoc()->setUseNat( onoff );
	m_doc->currentDocAsGenericDoc()->setOutgoingInterface( m_cb_external_interface->currentText () );
	KMFUndoEngine::instance()->endTransaction();
}

/*!
    \fn KMFGenericInterfaceNat::slotMasqueradeEnabled( bool )
 */
void KMFGenericInterfaceNat::slotMasqueradeEnabled( bool onoff ) {
	if ( m_doc->currentDocAsGenericDoc()->useMasquerade() == onoff ) {
		return;
	}
	KMFUndoEngine::instance()->startTransaction(
		m_doc->currentDocAsGenericDoc(),
		i18n( "%1 MASQUERADE target for NAT." ).arg( onoff ? i18n( "Enable" ) : i18n( "Disable" ) )
	);
	m_doc->currentDocAsGenericDoc()->setUseMasquerade( onoff );
	KMFUndoEngine::instance()->endTransaction();
}


/*!
    \fn KMFGenericInterfaceNat::slotAddressChanged( const TQString& )
 */
void KMFGenericInterfaceNat::slotAddressChanged( const TQString& ) {
	TQString address = "" + m_sb_addr_1->text() + "." +  m_sb_addr_2->text() + "." +  m_sb_addr_3->text() + "." +  m_sb_addr_4->text();
	if ( address == m_doc->currentDocAsGenericDoc()->natAddress()->toString() ) {
		return;
	}
	
	kdDebug() << "Updating NAT external address to: " << address << endl;
	KMFUndoEngine::instance()->startTransaction(
		m_doc->currentDocAsGenericDoc(),
		i18n( "Set NAT adddress to %1." ).arg( address )
	);
	m_doc->currentDocAsGenericDoc()->natAddress()->setAddress( m_sb_addr_1->value(),
														m_sb_addr_2->value(),
														m_sb_addr_3->value(),
														m_sb_addr_4->value() );
	KMFUndoEngine::instance()->endTransaction();
}
/*!
    \fn KMFGenericInterfaceNat::slotOutgoingInterfaceChanged( const TQString& )
 */
void KMFGenericInterfaceNat::slotExternalInterfaceChanged( const TQString& str ) {
	if ( m_doc->currentDocAsGenericDoc()->outgoingInterface() == str ) {
		return;
	}
	
	KMFUndoEngine::instance()->startTransaction(
		m_doc->currentDocAsGenericDoc(),
		i18n( "Change NAT outgoing interface to %1." ).arg( str )
	);
	m_doc->currentDocAsGenericDoc()->setOutgoingInterface( str );
	KMFUndoEngine::instance()->endTransaction();
	slotUpdateView();
}

}
#include "kmfgenericinterfacenat.moc"
