/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/*
Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2001-2004
*/

#include "xmlnames.h"

namespace KMF {

// Document Elements
const TQString& XML::GenericDoc_DocumentElement = "kmfgrs";
const TQString& XML::IPTDoc_DocumentElement = "kmfrs";
const TQString& XML::KMFNetwork_DocumentElement = "kmfnet";

// Elements
const TQString& XML::Protocol_Element = "protocol";
const TQString& XML::Table_Element = "table";
const TQString& XML::Chain_Element = "chain";
const TQString& XML::Rule_Element = "rule";
const TQString& XML::RuleOption_Element = "ruleoption";
const TQString& XML::RuleOptionValue_Element = "ruleoptionvalue";
const TQString& XML::Logging_Element = "logging";
const TQString& XML::Target_Element = "target";
const TQString& XML::ProtocolUsage_Element = "protocolusage";
const TQString& XML::Port_Element = "port";
const TQString& XML::Abstract_Element = "abstract";
const TQString& XML::ICMP_Element = "icmp";
const TQString& XML::NAT_Element = "nat";
const TQString& XML::NetHost_Element = "nethost";
const TQString& XML::NetZone_Element = "netzone";
const TQString& XML::FromIP_Element = "fromIP";
const TQString& XML::NetMask_Element = "netMask";
const TQString& XML::ProtocolCategory_Element = "protocolCategory";
const TQString& XML::Interface_Element = "interface";
const TQString& XML::OS_Element = "os";
const TQString& XML::BackEnd_Element = "backend";
const TQString& XML::Distribution_Element = "distribution";
const TQString& XML::InitPath_Element = "initPath";
const TQString& XML::IPTPath_Element = "IPTPath";
const TQString& XML::ModprobePath_Element = "modprobePath";
const TQString& XML::RcDefaultPath_Element = "rcDefaultPath";
const TQString& XML::TargetConfig_Element = "targetconfig";





// Attributes
const TQString& XML::Protocol_Attribute = "protocol";
const TQString& XML::Uuid_Attribute = "uuid";
const TQString& XML::Name_Attribute = "name";
const TQString& XML::Description_Attribute = "description";
const TQString& XML::GUIName_Attribute = "guiName";
const TQString& XML::Address_Attribute = "address";
const TQString& XML::ReadOnly_Attribute = "readonly";
const TQString& XML::Type_Attribute = "type";
const TQString& XML::TargetOption_Attribute = "targetoption";
const TQString& XML::BuiltIn_Attribute = "builtin";
const TQString& XML::DefaultTarget_Attribute = "default_target";
const TQString& XML::Logging_Attribute = "logging";
const TQString& XML::Target_Attribute = "target";
const TQString& XML::Prefix_Attribute = "prefix";
const TQString& XML::Limit_Attribute = "limit";
const TQString& XML::Burst_Attribute = "burst";
const TQString& XML::IO_Attribute = "io";
const TQString& XML::ProtocolUuid_Attribute = "protocolUuid";
const TQString& XML::Enabled_Attribute = "enabled";
const TQString& XML::CustomRule_Attribute = "custom_rule";
const TQString& XML::Num_Attribute = "num";
const TQString& XML::Version_Attribute = "version";
const TQString& XML::MinVersion_Attribute = "minVersion";
const TQString& XML::MaxVersion_Attribute = "maxVersion";
const TQString& XML::RestrictOutgoingConnections_Attribute = "restrictOutgoingConnections";
const TQString& XML::AllowIncomingConnections_Attribute = "allowIncomingConnections";
const TQString& XML::LogIncoming_Attribute = "logIncoming";
const TQString& XML::LogOutgoing_Attribute = "logOutgoing";
const TQString& XML::LimitRate_Attribute = "limitRate";
const TQString& XML::LimitScale_Attribute = "limitScale";
const TQString& XML::SSHPort_Attribute = "sshPort";


// Network
const TQString& XML::Interface_Attribute = "interface";

// GENERIC DOC
const TQString& XML::LogDropped_Attribute = "logDropped";
const TQString& XML::LimitLog_Attribute = "limitLog";
const TQString& XML::LogPrefix_Attribute = "logPrefix";
const TQString& XML::AllowPingReply_Attribute = "allowPingReply";
const TQString& XML::LimitPingReply_Attribute = "limitPingReply";
const TQString& XML::UseNat_Attribute = "useNat";
const TQString& XML::UseMasquerade_Attribute = "useMasquerade";
const TQString& XML::NatAddress_Attribute = "natAddress";
const TQString& XML::OutgoingInterface_Attribute = "outgoingInterface";

// IPTDOC
const TQString& XML::UseFilter_Attribute = "use_filter";
const TQString& XML::Use_Nat_Attribute = "use_nat";
const TQString& XML::UseMangle_Attribute = "use_mangle";
const TQString& XML::UseModules_Attribute = "use_modules";
const TQString& XML::UseRpFilter_Attribute = "use_rp_filter";
const TQString& XML::UseIPFwd_Attribute = "use_ipfwd";
const TQString& XML::UseSynCookies_Attribute = "use_syn_cookies";
const TQString& XML::UseMartians_Attribute = "use_martians";


// Values
const TQString& XML::Yes_Value = "yes";
const TQString& XML::No_Value = "no";
const TQString& XML::BoolOn_Value = "bool:on";
const TQString& XML::BoolOff_Value = "bool:off";
const TQString& XML::Undefined_Value = "UNDEFINED";
const TQString& XML::Incoming_Value = "INCOMING";
const TQString& XML::Outgoing_Value = "OUTGOING";
const TQString& XML::UDP_Value = "UDP";
const TQString& XML::TCP_Value = "TCP";
const TQString& XML::IPTablesGUIInterface_Value = "iptables";
const TQString& XML::GenericGUIInterface_Value = "generic";


// Constants 

const TQString& Constants::Localhost_Name = "localhost";
const TQString& Constants::Localhost_IP = "127.0.0.1";
const TQString& Constants::MyNetwork_Name = "mynetwork";
const TQString& Constants::FilterTable_Name = "filter";
const TQString& Constants::NatTable_Name = "nat";
const TQString& Constants::MangleTable_Name = "mangle";

const TQString& Constants::InputChain_Name = "INPUT";
const TQString& Constants::OutputChain_Name = "OUTPUT";
const TQString& Constants::ForwardChain_Name = "FORWARD";
const TQString& Constants::PreRoutingChain_Name = "PREROUTING";
const TQString& Constants::PostRoutingChain_Name = "POSTROUTING";

const TQString& Constants::StartFirewallJob_Name = "start_firewall_job";
const TQString& Constants::StopFirewallJob_Name = "stop_firewall_job";
const TQString& Constants::InstallFirewallJob_Name = "install_firewall_job";
const TQString& Constants::UninstallFirewallJob_Name = "uninstall_firewall_job";
const TQString& Constants::ShowConfigJob_Name = "show_config_job";
// const TQString& Constants::KdeSu_Cmd = "kdesu -t -i kmyfirewall -d -c ";

}

