//
// C++ Implementation: kprocesswrapper
//
// Description: 
//
//
// Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2008
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kprocesswrapper.h"

// QT Includes
#include <tqwidget.h>
#include <tquuid.h>
#include <tqfile.h>
#include <tqtextstream.h>

// KDE includes
#include <kapplication.h>
#include <kprocess.h>
#include <klocale.h>
#include <kdebug.h>
#include <kurl.h>
#include <ktempfile.h>
#include <kio/netaccess.h>

// Project includes
#include "kmftarget.h"

namespace KMF {

//##########  KMFUndoEngine  ##############
//#### static stuff
KProcessWrapper* KProcessWrapper::m_instance = 0;
KProcessWrapper* KProcessWrapper::instance() {
	if ( ! m_instance ) {
		m_instance = new KProcessWrapper( TQT_TQOBJECT(KApplication::kApplication()->mainWidget()) , "KProcessWrapper" );
	}
	return m_instance;
}
//##### end static stuff



KProcessWrapper::KProcessWrapper( TQObject* parent,  const char* name ) : TQObject( parent, name ) {
	m_stderrbuf = new TQString( "" );
	m_stdoutbuf = new TQString( "" );
	m_childproc = new KProcess();
	m_status = -1;
	m_exitedNormal = false;
	
	connect( m_childproc, TQT_SIGNAL( receivedStdout( KProcess*, char*, int ) ), this, TQT_SLOT( slotReceivedOutput( KProcess*, char*, int ) ) );
	connect( m_childproc, TQT_SIGNAL( receivedStderr( KProcess*, char*, int ) ), this, TQT_SLOT( slotReceivedError( KProcess*, char*, int ) ) );
	connect( m_childproc, TQT_SIGNAL( processExited( KProcess* ) ), this, TQT_SLOT( slotProcessExited( KProcess* ) ) ) ;
}

KProcessWrapper::~KProcessWrapper()
{
}

void KProcessWrapper::slotStartLocalJob( const TQString& jobName, const TQString& command, bool useKdeSu , bool synchronous = false  ) {
	kdDebug() << "Start Local Job: " << jobName << " " << command << endl;
	kdDebug() << "synchronous: " << synchronous << endl;
	m_jobName = jobName;
	*m_stdoutbuf = "";
	*m_stderrbuf = "";
	m_allOut = "";
	m_stdOut = "";
	m_stdErr = "";
	TQString localScriptFile = command;
	KTempFile *f = new KTempFile();
	if ( ! KIO::NetAccess::exists( localScriptFile, false, KApplication::kApplication()->mainWidget() ) ) {
		kdDebug() << "KProcessWrapper::slotStartLocalJob(...) - creating temporary script file." << endl;
		TQTextStream *ts = f->textStream();
		*ts << command << endl;
		f->sync();
		f->close();
		localScriptFile = f->name();
	}
	
	
	m_childproc->clearArguments();
	if ( useKdeSu ) {
		*m_childproc << "kdesu" << "-t" << "-i" << "kmyfirewall" << "--noignorebutton" << "-d" << "-c" << localScriptFile;
	} else {
		*m_childproc << "bash" << localScriptFile;
	}
	if ( synchronous ) {
		m_childproc->start( KProcess::Block, KProcess::AllOutput );
	} else {
		m_childproc->start( KProcess::NotifyOnExit, KProcess::AllOutput );
	}
	f->unlink();
	delete f;
} 

void KProcessWrapper::slotStartRemoteJob( const TQString& jobName, const TQString& scriptFile, KMFTarget* execHost ) {
	TQString localScriptFile = scriptFile;
	m_jobName = jobName;
	*m_stdoutbuf = "";
	*m_stderrbuf = "";
	m_allOut = "";
	m_stdOut = "";
	m_stdErr = "";
	KTempFile *f = new KTempFile();
	if ( ! KIO::NetAccess::exists( scriptFile, false, KApplication::kApplication()->mainWidget() ) ) {
		kdDebug() << "KProcessWrapper::slotStartRemoteJob(...) - creating temporary script file." << endl;
		TQTextStream *ts = f->textStream();
		*ts << scriptFile << endl;
		f->sync();
		f->close();
		localScriptFile = f->name();
	}
	
	
	TQUuid uuid = TQUuid::createUuid();
	KURL remFileUrl(  execHost->getFishUrl() + "/tmp/" + uuid.toString() );
	kdDebug() << "UPLOADING: Temporary script file: " << localScriptFile << " to: " << remFileUrl.url() <<  endl;
	
	if ( ! KIO::NetAccess::upload( localScriptFile, remFileUrl, KApplication::kApplication()->mainWidget() ) ) {
		kdDebug() << "ERROR: Could not upload temp file." << endl;
		m_exitedNormal = false;
		m_status = 1;
		m_stdErr = i18n( "Could not upload the temporary comand script file." );
		// m_allOut = m_stdErr;
		m_stdOut = "";
		emit sigProcessFinished( m_jobName, m_status, m_exitedNormal, m_stdOut, m_stdErr, m_allOut );
		
		
		return;	
	}
	f->unlink();
	delete f;
	
	TQString cmd = "bash /tmp/" + uuid.toString();
	kdDebug() << "Execute: " << cmd << " at: " << execHost->getFishUrl() << endl;
	const TQString& ret = KIO::NetAccess::fish_execute( execHost->getFishUrl(), cmd, KApplication::kApplication()->mainWidget() ); 
	if ( ! KIO::NetAccess::del( remFileUrl, KApplication::kApplication()->mainWidget() ) ) {
		m_exitedNormal = false;
		m_status = 1;
		m_stdErr = i18n( "Could not delete the temporary comand script file." );
		// m_allOut = m_stdErr;
		m_stdOut = "";
		emit sigProcessFinished( m_jobName, m_status, m_exitedNormal, m_stdOut, m_stdErr, m_allOut );
		return;	
	}
	kdDebug() << "Got Output:" << ret << endl;
	
	
	const TQString& resultVal = ret.right( ret.find( "\n###RESULT:" ) + 10 );
	kdDebug() << "resultVal: " << resultVal << endl;
	m_status = 0;
	if ( ret.contains( "###RESULT: 0" ) == 0 ) {
		 m_status = 1;
	} 
	
	
	const TQString& retNew = ret.left( ret.find( "\n###RESULT:" ) );
	
	kdDebug() << "Real Output: " << retNew << endl;
	
	m_allOut = retNew;
	m_stdErr = retNew;
	m_stdOut = retNew;
	
	m_exitedNormal = true;
	
	
	emit sigProcessFinished( m_jobName, m_status, m_exitedNormal, retNew, retNew, retNew );
} 



void KProcessWrapper::slotKillJob() {
	kdDebug() << "void KProcessWrapper::killJob()" << endl;
	m_childproc->kill();
}

void KProcessWrapper::slotReceivedOutput( KProcess *, char *buffer, int buflen ) {
	kdDebug() << "KProcessWrapper::slotReceivedOutput( KProcess *, char *buffer, int buflen )" << endl;
	if ( !m_stderrbuf->isEmpty() ) {
		m_allOut.append( *m_stderrbuf );
		m_stdErr.append( *m_stderrbuf );
		emit sigReceivedStdErr( m_jobName,  *m_stderrbuf );
		*m_stderrbuf = "";
	}

	*m_stdoutbuf += TQString::fromLatin1( buffer, buflen );
	m_allOut.append( *m_stdoutbuf );
	m_stdOut.append( *m_stdoutbuf );
	
	emit sigReceivedStdOut( m_jobName, *m_stdoutbuf );
	*m_stdoutbuf = "";
	
	
// 	int pos;
// 	while ( ( pos = m_stdoutbuf->find( '\n' ) ) != -1 ) {
// 		TQString line = m_stdoutbuf->left( pos );
// 		m_allOut.append( *m_stdoutbuf );
// 		m_stdOut.append( *m_stdoutbuf );
// 		m_stdoutbuf->remove( 0, pos + 1 );
// 	}
}

void KProcessWrapper::slotReceivedError( KProcess *, char *buffer, int buflen ) {
	kdDebug() << "KProcessWrapper::slotReceivedError( KProcess *, char *buffer, int buflen )" << endl;
	// Flush stdout buffer
	if ( !m_stdoutbuf->isEmpty() ) {
		// Do What
		m_allOut.append( *m_stdoutbuf );
		m_stdOut.append( *m_stdoutbuf );
		*m_stdoutbuf = "";
	}

	*m_stderrbuf += TQString::fromLatin1( buffer, buflen );
	m_allOut.append( *m_stderrbuf );
	m_stdErr.append( *m_stderrbuf );
	*m_stderrbuf = "";
	
/*	int pos;
	while ( ( pos = m_stderrbuf->find( '\n' ) ) != -1 ) {
		TQString line = m_stderrbuf->left( pos );
		m_allOut.append( line );
		m_stdErr.append( line );
		m_stderrbuf->remove( 0, pos + 1 );
	}*/
}

void KProcessWrapper::slotProcessExited( KProcess* ) {
	kdDebug() << "KProcessWrapper::slotProcessExited()" << endl;
	m_status = m_childproc->exitStatus();
	m_exitedNormal = m_childproc->normalExit();
	
	
	emit sigProcessFinished( m_jobName, m_status, m_exitedNormal, m_stdOut, m_stdErr, m_allOut );
	return;
}


//##





} // end namespace KMF
