//
// C++ Interface: kmfprotocolcategory
//
// Description: 
//
//
// Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KMFPROTOCOLCATEGORY_H
#define KMFPROTOCOLCATEGORY_H

#include "netfilterobject.h"

// QT includes
#include <tqstringlist.h>
#include <tqstring.h>
#include <tqguardedptr.h>
#include <tqvaluelist.h>
#include <tqmap.h>
#include <tquuid.h>
#include <tqobject.h>

// KDE includes
#include <kdemacros.h>
#include <kurl.h>

namespace KMF {
class KMFProtocol;

/**
	@author Christian Hubinger <chubinger@irrsinnig.org>
*/

class KDE_EXPORT KMFProtocolCategory : public NetfilterObject
{
Q_OBJECT
  TQ_OBJECT
public:
	static KMFProtocolCategory* createCategory( const TQString& name );
	
	
	static KMFProtocolCategory* getCustomCategory();
	
private:	
	static const TQUuid& customCategoryUuid();
	static const TQUuid& miscCategoryUuid();
	
public:
   
   ~KMFProtocolCategory();
	KMFProtocol* createProtocol( const TQString& name );
	
	TQValueList< KMFProtocol* >& protocols() const;

	
	
	KMFProtocol* findProtocolByUuid( const TQUuid& name ) const;
	
	virtual int type();
	virtual void clear();
	virtual const TQDomDocument& getDOMTree();
	virtual void loadXML(const TQDomDocument&, TQStringList& errors );
	virtual void loadXML( TQDomNode, TQStringList& errors );
	
	void delProtocol( KMFProtocol*, bool destructive /* = false */);
	
public slots:
	void slotOnProtocolDeleted( TQObject* protocol );
	
private:
	KMFProtocol* findProtocolByName( const TQString& name ) const;
	
	KMFProtocol* addProtocol( KMFProtocol* );
	

private: // DATA
	KMFProtocolCategory( NetfilterObject* parent, const char* name );
	TQString m_icon;
	TQValueList< KMFProtocol* > m_protocols;


};
}
#endif
