//
// C++ Interface: kmfpluginfactory
//
// Description:
//
//
// Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
// License: GPL
//
#ifndef KMFPLUGINFACTORY_H
#define KMFPLUGINFACTORY_H

/**
@author Christian Hubinger
*/
// QT includes
#include <tqstring.h>
#include <tqptrlist.h>
#include <tqvaluelist.h>
// KDE includes
// #include <kparts>
#include <kparts/part.h>
#include <kparts/mainwindow.h>

class TQObject;
namespace KMF {
class KMFTarget;
class KMFError;
class KMFCompilerInterface;
class KMFInstallerInterface;
class KMFRuleOptionEditInterface;
class KMFRuleTargetOptionEditInterface;


class KDE_EXPORT KMFPluginFactory {
	friend class KMFTarget;
private:
	KMFPluginFactory();
	~KMFPluginFactory();
public:
static TQPtrList<KMFRuleOptionEditInterface>* KMFRuleOptionEditors(  TQObject *parent );

static TQPtrList<KMFRuleTargetOptionEditInterface>* KMFRuleTargetOptionEditors( TQObject *parent );
static TQValueList<KMFCompilerInterface*>* CompilersForInstaller( const TQString& osName  );

static KParts::ReadWritePart* KMFMainView( KParts::MainWindow* parent, KMFError* err );

private:
static KMFCompilerInterface* KMFCompiler( KMFTarget* ); 
static KMFInstallerInterface* KMFInstaller( KMFTarget* ); 


};
}
#endif
