/***************************************************************************
 begin                : Tue Aug 6 2002
 copyright            : (C) 2002 by Christian Hubinger
 email                : chubinger@irrsinnig.org
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kmferror.h"

// QT includes
#include <tqstring.h>

// KDE includes
#include <kdebug.h>
#include <klocale.h>



//############# static ##############//

namespace KMF {

KMFError* KMFError::parseErrors( TQStringList& errors ) {
	KMFError *err = new KMFError();
	TQStringList::iterator it = errors.begin();
	TQString msg = "";
	while( it != errors.end() ) {
		TQString s = *it;
		kdDebug() << "Parsing Error: " << s << endl;
		msg += s;
		if ( s.contains( i18n("WARNING: ") ) != 0 && err->errType() == KMFError::OK  ) {
			err->setErrType( KMFError::HINT );
		} else if ( s.contains( i18n("ERROR: ") ) != 0 ) {
			err->setErrType( KMFError::FATAL );
		}
		++it;
	}
	
	err->setErrMsg( msg );
	return err;
}

const TQString& KMFError::getAsString( int error_type, const TQString& msg ) {
	TQString s;
	s += "<b>";
	if ( error_type == KMFError::OK ) {
		s += "<font color=\"green\">" + i18n("SUCCESS: ");
	} else if ( error_type == KMFError::WARNING ||  error_type == KMFError::HINT ) {
		s += "<font color=\"orange\">" + i18n("WARNING: ");
	} else {
		s += "<font color=\"red\">" + i18n("ERROR: ");
	}
	s += "</font></b> ";
	s += msg;
	s += "<br />";
	return *( new TQString( s ) );
}

//########### end static ##############//
KMFError::KMFError() {
	//  kdDebug() << "Creating new KMFError Object" << endl;
	m_err_type = -1;
	m_err_msg = "";
	m_err_num = -1;

}
KMFError::~KMFError() {}

void KMFError::setErrMsg( const TQString &msg ) {
	m_err_msg = msg;
}

void KMFError::setErrType( int type  ) {
//	kdDebug() << "KMFError::setErrType( int type  ) - Setting Error Type: "  << type << endl;
	if ( type == OK ) {
		m_err_type = OK;
		m_err_num = 0;
	} else if ( type == HINT ) {
		m_err_type = HINT;
		m_err_num = 0;
	} else if ( type == NORMAL ) {
		m_err_type = NORMAL;
		m_err_num = NORMAL;
	} else if ( type == FATAL ) {
		m_err_type = FATAL;
		m_err_num = FATAL;
	}
}

}












