/**
 * Copyright (C) 2005 by Koos Vriezen <koos ! vriezen ? gmail ! com>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License version 2 as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 **/

#ifndef KMPLAYER_CONTROLPANEL_H
#define KMPLAYER_CONTROLPANEL_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

#include <tqwidget.h>
#include <tqpushbutton.h>

#include <kpopupmenu.h>

class TQSlider;
//class TQPushButton;
class TQBoxLayout;
class TQStringList;
class KPopupMenu;

namespace KMPlayer {

class View;

/*
 * A button from the controlpanel
 */
class KMPLAYER_NO_EXPORT KMPlayerMenuButton : public TQPushButton {
    Q_OBJECT
  TQ_OBJECT
public:
    KMPlayerMenuButton (TQWidget *, TQBoxLayout *, const char **, int = 0);
    KDE_NO_CDTOR_EXPORT ~KMPlayerMenuButton () {}
signals:
    void mouseEntered ();
protected:
    void enterEvent (TQEvent *);
};

/*
 * The pop down menu from the controlpanel
 */
class KMPLAYER_EXPORT KMPlayerPopupMenu : public KPopupMenu {
    Q_OBJECT
  TQ_OBJECT
public:
    KMPlayerPopupMenu (TQWidget *);
    KDE_NO_CDTOR_EXPORT ~KMPlayerPopupMenu () {}
signals:
    void mouseLeft ();
protected:
    void leaveEvent (TQEvent *);
};

/*
 * The volume bar from the controlpanel
 */
class KMPLAYER_EXPORT VolumeBar : public TQWidget {
    Q_OBJECT
  TQ_OBJECT
public:
    VolumeBar (TQWidget * parent, View * view);
    ~VolumeBar ();
    KDE_NO_EXPORT int value () const { return m_value; }
    void setValue (int v);
signals:
    void volumeChanged (int); // 0 - 100
protected:
    void wheelEvent (TQWheelEvent * e);
    void paintEvent (TQPaintEvent *);
    void mousePressEvent (TQMouseEvent * e);
    void mouseMoveEvent (TQMouseEvent * e);
private:
    View * m_view;
    int m_value;
};

/*
 * The controlpanel GUI
 */
class KMPLAYER_EXPORT ControlPanel : public TQWidget {
    Q_OBJECT
  TQ_OBJECT
public:
    enum MenuID {
        menu_config = 0, menu_player, menu_fullscreen, menu_volume, 
        menu_bookmark, menu_zoom, menu_zoom50, menu_zoom100,
        menu_zoom150, menu_zoom200, menu_zoom300,
        menu_view, menu_video, menu_playlist, menu_minimal
    };
    enum Button {
        button_config = 0, button_playlist,
        button_back, button_play, button_forward,
        button_stop, button_pause, button_record,
        button_broadcast, button_language,
        button_red, button_green, button_yellow, button_blue,
        button_last
    };
    ControlPanel (TQWidget * parent, View * view);
    KDE_NO_CDTOR_EXPORT ~ControlPanel () {}
    void showPositionSlider (bool show);
    void enableSeekButtons (bool enable);
    void enableRecordButtons (bool enable);
    void setPlaying (bool play);
    void setRecording (bool record);
    void setAutoControls (bool b);
    void setPalette (const TQPalette &);
    int preferedHeight ();
    KDE_NO_EXPORT bool autoControls () const { return m_auto_controls; }
    KDE_NO_EXPORT TQSlider * positionSlider () const { return m_posSlider; }
    KDE_NO_EXPORT TQSlider * contrastSlider () const { return m_contrastSlider; }
    KDE_NO_EXPORT TQSlider * brightnessSlider () const { return m_brightnessSlider; }
    KDE_NO_EXPORT TQSlider * hueSlider () const { return m_hueSlider; }
    KDE_NO_EXPORT TQSlider * saturationSlider () const { return m_saturationSlider; }
    TQPushButton * button (Button b) const { return m_buttons [(int) b]; }
    KDE_NO_EXPORT TQPushButton * broadcastButton () const { return m_buttons[button_broadcast]; }
    KDE_NO_EXPORT VolumeBar * volumeBar () const { return m_volume; }
    KDE_NO_EXPORT KMPlayerPopupMenu * popupMenu () const { return m_popupMenu; }
    KDE_NO_EXPORT KPopupMenu * bookmarkMenu () const { return m_bookmarkMenu; }
    KDE_NO_EXPORT TQPopupMenu * zoomMenu () const { return m_zoomMenu; }
    KDE_NO_EXPORT TQPopupMenu * playerMenu () const { return m_playerMenu; }
    KDE_NO_EXPORT TQPopupMenu * colorMenu () const { return m_colorMenu; }
    KDE_NO_EXPORT TQPopupMenu * audioMenu () const { return m_audioMenu; }
    KDE_NO_EXPORT TQPopupMenu * subtitleMenu () const { return m_subtitleMenu; }
    KDE_NO_EXPORT View * view () const { return m_view; }
public slots:
    void setLanguages (const TQStringList & al, const TQStringList & sl);
    void selectSubtitle (int id);
    void selectAudioLanguage (int id);
    void showPopupMenu ();
    void showLanguageMenu ();
    void setPlayingProgress (int position, int length);
    void setLoadingProgress (int pos);
protected:
    void timerEvent (TQTimerEvent * e);
    void setupPositionSlider (bool show);
private slots:
    void buttonMouseEntered ();
    void buttonClicked ();
    void menuMouseLeft ();
private:
    enum { progress_loading, progress_playing } m_progress_mode;
    int m_progress_length;
    int m_popup_timer;
    int m_popdown_timer;
    int m_button_monitored;
    View * m_view;
    TQBoxLayout * m_buttonbox;
    TQSlider * m_posSlider;
    TQSlider * m_contrastSlider;
    TQSlider * m_brightnessSlider;
    TQSlider * m_hueSlider;
    TQSlider * m_saturationSlider;
    TQPushButton * m_buttons [button_last];
    VolumeBar * m_volume;
    KMPlayerPopupMenu * m_popupMenu;
    KMPlayerPopupMenu * m_bookmarkMenu;
    KMPlayerPopupMenu * m_zoomMenu;
    KMPlayerPopupMenu * m_playerMenu;
    KMPlayerPopupMenu * m_colorMenu;
    KMPlayerPopupMenu * m_languageMenu;
    KMPlayerPopupMenu * m_audioMenu;
    KMPlayerPopupMenu * m_subtitleMenu;
    bool m_auto_controls; // depending on source caps
    bool m_popup_clicked;
};

}

#endif // KMPLAYER_CONTROLPANEL_H
