/***************************************************************************
 *   Copyright (C) 2007 by Frode M. Døving   *
 *   frode@lnix.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/


#include "kio_umountwrapper.h"
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <klocale.h>
#include <kdebug.h>


static const char description[] =
    I18N_NOOP("Safely remove wrapper. Provides progress dialog.");

static const char version[] = "0.2";

static KCmdLineOptions options[] =
{
    { "+[URL]", I18N_NOOP( "URL to Safely Remove" ), 0 },
    KCmdLineLastOption
};

int main(int argc, char **argv)
{
    KAboutData about("kio_umountwrapper", I18N_NOOP("kio_umountwrapper"), version, description,
		     KAboutData::License_GPL, "(C) 2007 Frode M. Døving", 0, 0, "frode@lnix.net");
    about.addAuthor( "Frode M. Døving", 0, "frode@lnix.net" );
    KCmdLineArgs::init(argc, argv, &about);
    KCmdLineArgs::addCmdLineOptions( options );

    kio_umountwrapper *app;

    KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
    kdDebug() << "arg0: " << args->arg(0) << endl;

    if (args->count() == 0)
        KCmdLineArgs::usage(i18n("No URL specified!"));
    else app = new kio_umountwrapper(TQString(args->arg(0)));

    args->clear();

    return app->exec();
}

