/***************************************************************************
 *   Copyright (C) 2007 by Frode M. Døving   *
 *   frode@lnix.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/


#include "kio_umountwrapper.h"

#include <cstdlib>
#include <tqtimer.h>

#include <kapplication.h>
#include <klocale.h>
#include <kprogress.h>
#include <kprocess.h>
#include <kcmdlineargs.h>
#include <kdebug.h>

kio_umountwrapper::kio_umountwrapper(const TQString& url)
    : KApplication()
{
    m_progress = new KProgressDialog();
    setMainWidget(m_progress);
    m_progress->setLabel(i18n("Synchronising data to disk, please wait")+"...");
    m_progress->setAutoClose(true);
    m_progress->setAllowCancel(false);
    m_progress->progressBar()->setTextEnabled(false);
    m_progress->progressBar()->setTotalSteps(0);
    m_progress->show();

    TQTimer *t = new TQTimer(this);
    connect(t, TQT_SIGNAL(timeout()), TQT_SLOT(progressAdvance()));
    t->start(10, FALSE);

    KProcess *p = new KProcess(TQT_TQOBJECT(this));
    *p << "kio_media_mounthelper";
    *p << "-s";
    *p << url;
    kdDebug() << "KProcess: " << url << endl;
    connect(p, TQT_SIGNAL(processExited(KProcess *)),
    this, TQT_SLOT(processFinished(KProcess *)));
    p->start();
}

void kio_umountwrapper::progressAdvance()
{
    m_progress->progressBar()->advance(1);
}

void kio_umountwrapper::processFinished(KProcess* p)
{
    if (p->normalExit() && p->exitStatus() == 0)
    {
        ::exit(0);
    }
    else
    {
        ::exit(1);
    }
}

#include "kio_umountwrapper.moc"
