/***************************************************************************
 *   Copyright (C) 2007 by Ken Werner                                      *
 *   ken.werner@web.de                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#ifndef THREADEDTRIGGER_H
#define THREADEDTRIGGER_H

#include "source.h"
#include "updateevent.h"
#include "triggeredsource.h"
#include <tqwaitcondition.h>
#include <tqmutex.h>
#include <tqthread.h>
#include <tqevent.h>
#include <tqobject.h>

/**
 * ThreadedTrigger calls the fetchValue method of a source asynchronous using a thread
 * @author Ken Werner
 */
class ThreadedTrigger : public TQObject, TQThread{
	Q_OBJECT
	TQ_OBJECT //macro which activates signals and slots (tqmoc)
public:
	/**
	 * Creates a new ThreadedTrigger
	 */
	ThreadedTrigger(TriggeredSource* inSource, unsigned long inRefreshSleep = 1000);
	
	virtual ~ThreadedTrigger();

protected:
	/**
	 * fetches tcalls the fetchValue method periodically
	 * and sends an UpdateEvent to the source
	 */
    virtual void run();

protected slots:
	/**
	 * enables (starts the thread) or disables (stops the thread)
	 * this method is called if mSource gets enabled or disabled
	 */
	void enable(bool inEnable);

private:
	/**
	 * pointer to the TriggeredSource
	 **/
	 TriggeredSource* mSource;

	/**
	 * time in milli seconds between two value fetches
	 */
	unsigned long mRefreshSleep;

    /**
     * indicates whether this thread runs
     */
    bool mRunning;
    
    /*
     * this is the condition, on which this thread sleeps 
     * mRefreshSleep milliseconds.
     */
    TQWaitCondition mWaitCond;

    /*
     * this mutex ensures that the thread always sleeps on the
     * condition, if we signal it.
     */
    TQMutex mWaitMutex;
};
#endif //THREADEDTRIGGER_H
