/***************************************************************************
 *   Copyright (C) 2006 by Ken Werner                                      *
 *   ken.werner@web.de                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#include "hwmonthermalsrc.h"
#include <tqtextstream.h> 
#include <tqdir.h>
#include <klocale.h>

HwMonThermalSrc::HwMonThermalSrc(TQWidget* inParent, const TQFile& inSourceFile, unsigned int inIndex):
		LabelSource(inParent),
		mSourceFile(inSourceFile.name()),
		mTrigger(this, 3000){
	//mName = "HwMon " + inSourceFile.name()[inSourceFile.name().length() - 7];
	mID = "hwmon" + TQString::number(inIndex);
	mName = mID;
	mDescription = i18n("This thermal source is provided by hwmon. (%1)").arg(inSourceFile.name());
}

HwMonThermalSrc::~HwMonThermalSrc(){
}

std::list<Source*>HwMonThermalSrc::createInstances(TQWidget* inParent){
	std::list<Source*> list;
	// /sys/class/hwmon/*/device/temp*_input
	TQDir d("/sys/class/hwmon/");
	TQDir subd;
	TQString device = "/device";
	// check the i2c interface if hwmon isn't available	
	// /sys/bus/i2c/devices/*/temp*_input	
	if(!d.exists()){
		d.setPath("/sys/bus/i2c/devices/");
		device = "";
	}

	if(d.exists()){
		unsigned int index = 1;
		d.setFilter(TQDir::Dirs);
		d.setSorting(TQDir::Name);
		for(unsigned int i = 0; i < d.count(); i++ ){
			if((d[i] != ".") && (d[i] != "..")){
				subd = d.canonicalPath() + "/" + d[i] + device;
				subd.setFilter(TQDir::Files);
				subd.setSorting(TQDir::Name);
				for(unsigned int j = 0; j < subd.count(); j++){ 
					if((subd[j] != ".") && (subd[j] != "..") && (TQDir::match(subd.canonicalPath() + "/temp*_input", subd.canonicalPath() + "/" + subd[j]))){
						TQFile f(subd.canonicalPath() + "/" + subd[j]);
						if(f.open(IO_ReadOnly)){
							TQTextStream textStream( &f );
							TQString s = textStream.readLine();
							f.close();
							if(!s.startsWith("-")){
								list.push_back(new HwMonThermalSrc(inParent, f, index));
								index++;
							}
						}
					}
				}
			}
		}
	}
	return list;
}

TQString HwMonThermalSrc::fetchValue(){
	TQString s = "n/a";
	if(mSourceFile.open(IO_ReadOnly)){
		TQTextStream textStream( &mSourceFile );
		s = textStream.readLine();
		mSourceFile.close();
		s = s.stripWhiteSpace();
		if(s.length() > 3)
			s = s.remove(s.length() - 3, 3);
		s = formatTemperature(s);
	}
	return s;
}

