/***************************************************************************
 *   Copyright (C) 2006 by Ken Werner                                      *
 *   ken.werner@web.de                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#include "acpithermalsrc.h"
#include <tqtextstream.h> 
#include <tqdir.h>
#include <klocale.h>

ACPIThermalSrc::ACPIThermalSrc(TQWidget* inParent, const TQFile& inSourceFile):
		LabelSource(inParent),
		mSourceFile(inSourceFile.name()),
		mTrigger(this){
	mID = mSourceFile.name().section('/', -2, -2, TQString::SectionSkipEmpty);
	mName = mID;
	mDescription = i18n("This source is provided by the Linux ACPI Thermal Zone driver.");
}

ACPIThermalSrc::~ACPIThermalSrc(){
}

std::list<Source*>ACPIThermalSrc::createInstances(TQWidget* inParent){
	std::list<Source*> list;
	TQDir d( "/proc/acpi/thermal_zone" );
	if( d.exists() ){
		d.setFilter( TQDir::Dirs | TQDir::NoSymLinks );
		d.setSorting( TQDir::Name);
		for( unsigned int i = 0; i < d.count(); i++ ){
			if((d[i] != ".") && (d[i] != "..")){
				TQFile acpiFile(d.canonicalPath() + "/" + d[i] + "/temperature");
				list.push_back(new ACPIThermalSrc(inParent, acpiFile));
			}
		}
	}
	return list;
}

TQString ACPIThermalSrc::fetchValue() {
	TQString s = "n/a";
	if(mSourceFile.open(IO_ReadOnly)){
		TQTextStream textStream(&mSourceFile);
		s = textStream.readLine();
		mSourceFile.close();
		s = s.remove("temperature:").stripWhiteSpace();
		s = formatTemperature(s.left(s.length()-1));
	}
	return s;
}

