/***************************************************************************
 *   Copyright (C) 2006 by Valentine Sinitsyn                              *
 *   e_val@inbox.ru                                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
#ifndef CPUFREQD_H
#define CPUFREQD_H

#include "cpufreqdconnection.h"
#include "cpufreqdprofile.h"
#include <tqaction.h>
#include <tqobject.h>
#include <tqpopupmenu.h>
#include <tqstring.h>
#include <tqsignalmapper.h>
#include <tqvaluevector.h>
#include <tqptrlist.h>
#include <stdint.h>

class CPUFreqd: public TQObject {
	Q_OBJECT
  TQ_OBJECT

	public:
		CPUFreqd();
		virtual ~CPUFreqd();

		bool enabled() const;
		TQValueVector<CPUFreqdProfile> & getProfiles(bool reconnect = false);
		TQPopupMenu* menu();

	public slots:
		void setManual();
		void setDynamic();
		void setProfile(int id);

	private:
		CPUFreqdConnection m_conn;
		TQValueVector<CPUFreqdProfile> m_profiles;
		TQPopupMenu *m_menu;
		TQSignalMapper *m_mapper;
		TQAction* m_dynamic;
		TQActionGroup* m_items;
		TQPtrList<TQAction>* m_actions;

		void setMode(uint32_t mode);

	private slots:
		void updateMenu();
};

#endif
