/***************************************************************************
                           tabulardialog.h
----------------------------------------------------------------------------
    date                 : Sep 17 2006
    version              : 0.26
    copyright            : (C) 2005-2006 by Holger Danielsson
    email                : holger.danielsson@t-online.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef TABULARDIALOG_H
#define TABULARDIALOG_H

#include "kilewizard.h"
#include "latexcmd.h"

#include <tqevent.h>
#include <tqpainter.h>
#include <tqtable.h>
#include <tqcheckbox.h>
#include <tqradiobutton.h>
#include <tqcombobox.h>
#include <tqspinbox.h>
#include <tqregexp.h>
#include <tqvalidator.h>
#include <tqpopupmenu.h>

#include <kdialogbase.h>
#include <kcolorcombo.h>
#include <kpushbutton.h>
 
namespace KileDialog
{

namespace TabularCell
{
	enum { cbNone=0, cbLeft=1, cbTop=2, cbRight=4, cbBottom=8 };
	enum { cfNormal=0, cfBold=1, cfItalic=2 };
	
	struct Data
	{
		int align;
		int font;
		int border;
		TQColor bgcolor;
		TQColor textcolor;
	};
		
	struct Count
	{
		int bold;
		int italic;
		int bgcolor;
		int textcolor;
		int cells;
		TQString nameBgcolor;
		TQString nameTextcolor;
	};

	struct Preamble
	{
		bool vline;
		bool bold;
		bool italic;
		int align;
		TQString bgcolor;
		TQString textcolor;
	};
	
	struct CountLines
	{
		int cnt;
		int cells;
		TQValueList<int> list;
	};

}

class TabCellFrame : public TQFrame  
{
	Q_OBJECT
  TQ_OBJECT
public:
	
	TabCellFrame(TQWidget* parent);
	void setBorder(int value);
	int border() { return m_border; }
	
protected:
	void drawContents(TQPainter *p);
	void mousePressEvent(TQMouseEvent *event);
	void mouseDoubleClickEvent(TQMouseEvent *event);
	
private:
	int m_border;
	TQRect m_left,m_top,m_right,m_bottom;
};


class TabCellDialog : public KDialogBase  
{
	Q_OBJECT
  TQ_OBJECT

public:
	TabCellDialog(TQWidget *parent, TabularCell::Data *data,
	              const TQString &headerlabel, const TQStringList &alignlist);
	~TabCellDialog() {}
	
	TabularCell::Data data();
	TQString header();
	
private slots:
	void slotFramebuttonClicked();
	void slotSeparatorClicked();
	void slotResetClicked();

private:
	TQComboBox *m_coHeader;
	TQCheckBox *m_cbBold, *m_cbItalic;
	TQRadioButton *m_rbAlignleft, *m_rbAligncenter, *m_rbAlignright;
	KColorCombo *m_ccBgcolor, *m_ccTextcolor;
	KPushButton *m_pbFrame1,*m_pbFrame2,*m_pbFrame3,*m_pbFrame4;
	TQCheckBox *m_cbPre, *m_cbPost, *m_cbAt, *m_cbSep;	
	TabCellFrame *m_cellframe;

	TabularCell::Data m_data;
	bool m_header;
	TQString m_headerlabel;
	TQStringList m_preamblelist;
	
	void initWidgets();
	void initWidgetData();
};

//////////////////////////////////////////////////////////////////////

class TabularItem :public TQTableItem 
{
public:
	TabularItem(TQTable* table);
	TabularItem(TQTable* table, const TabularCell::Data &data);

	int alignment() const;
	bool isDefault();
	bool isMulticolumn();
	
	void paint(TQPainter *p,const TQColorGroup &cg,const TQRect &cr,bool selected);
	TabularCell::Data m_data;
};

class TabularDialog;
class TabularTable : public TQTable 
{
	Q_OBJECT
  TQ_OBJECT
	
public:
	TabularTable(int numRows,int numCols,TQWidget* parent, TabularDialog *tabdialog);

	void setText(int row,int col,const TQString &text);	
	void setAlignment(int row,int col,int align);
	TabularCell::Data defaultAttributes();
	
	bool isMulticolumn(int row,int col);
		
	void paintCell( TQPainter *p, int row, int col,
	                const TQRect &cr, bool selected, const TQColorGroup &cg );
	void updateCurrentCell();
	
	bool isRowEmpty(int row);
	bool isRowEmpty(int row,int col1, int col2);
	bool isColEmpty(int col);
	void clearHorizontalHeader(int col1,int col2);
	void clearVerticalHeader(int row1,int row2);

	bool isVLine(int row,int col, bool left);
	TabularCell::Count countCells(int x1,int y1,int x2,int y2);
	TabularCell::CountLines countHLines(int row, bool top);
	TabularCell::CountLines countVLines(int col, bool left);

protected:
	void endEdit(int row,int col,bool accept,bool replace);
	void activateNextCell();
	
private:
	enum { DataAlign, DataFont, DataBorder, DataBgcolor, DataTextcolor };
	enum { PopupNone, PopupEdit, PopupSet, PopupBreak, 
	       PopupLeft, PopupCenter, PopupRight, 
	       PopupText, PopupAttributes, PopupAll };
	 
	TabularItem *cellItem(int row,int col);
	bool isDefaultAttr(const TabularCell::Data &data);
	bool updateCell(int row,int col);
	void setAttributes(int row,int col,const TabularCell::Data &data);
	void clearAttributes(int row,int col);
	void cellParameterDialog(int x1,int y1,int x2,int y2, TabularCell::Data *data,
	                         const TQString &headerlabel);
	bool equalParameter(int x1,int y1,int x2,int y2, int code);
	
	void mouseContextHorizontalHeader(int pos);
	void mouseContextVerticalHeader(int pos);
	void updateHeaderAlignment(int col1,int col2,TQChar alignchar);
	
	bool getCurrentSelection(int &x1,int &y1,int &x2,int &y2);
	void clearSelectionCells(bool cleartext,bool clearattributes);
	void clearHeaderCells(bool cleartext,bool clearattributes);
	void clearCellrange(int x1,int y1,int x2,int y2,bool cleartext,bool clearattributes);
	void setCellrangeAlignment(int x1,int y1,int x2,int y2,int align);
	void setCellrangeAttributes(int x1,int y1,int x2,int y2,const TabularCell::Data &data);
	
	void setColspan(int row,int col1,int col2,int numcols,const TQString &text);
	void getCellRange(int row,int col1, int col2, int &xl, int &xr);
	TQString getCellRangeText(int row,int col1, int col2);

	TQPopupMenu *createPopupMenu();
	void insertPopupAlign(TQPopupMenu *popup,bool header);
	void insertPopupClear(TQPopupMenu *popup);
	int popupId(TQPopupMenu *popup, int id);
	
	void cellPopupEdit();
	void cellPopupSetMulticolumn();
	void cellPopupBreakMulticolumn();
	void cellPopupAlign(int align);
	
	void setupContextHeaderPopup(bool horizontal, int section);
	void headerPopupEdit();
	void headerPopupAlign(TQChar alignchar);
	
	bool m_horizontal;
	int m_section;
	int m_x1,m_y1,m_x2,m_y2;
	
	TQPopupMenu *m_headerpopup;
	TQPopupMenu *m_cellpopup;
	TabularDialog *m_tabdialog;
	
private slots:
	void slotContextMenuClicked(int row,int col,const TQPoint &);	
	void slotCellPopupActivated(int id);
	void slotHeaderPopupActivated(int id);
	
protected:
	bool eventFilter(TQObject *o, TQEvent *e); 

};


class TabularDialog : public Wizard  
{
	Q_OBJECT
  TQ_OBJECT

public:
	TabularDialog(TQWidget *parent, KConfig *config, KileDocument::LatexCommands *commands, bool tabularenv= true);
	~TabularDialog() {}
	TQStringList columnAlignments();

public slots:
	void slotOk();
	void slotRowValueChanged(int value);

private slots:
	void slotColValueChanged(int value);
	void slotEnvironmentChanged(const TQString &env);
	
private:
	KileDocument::LatexCommands *m_latexCommands;
	
	TabularTable *m_table;
	TQComboBox *m_coEnvironment, *m_coParameter;
	TQSpinBox *m_spRows, *m_spCols;
	TQCheckBox *m_cbWarning, *m_cbBullets, *m_cbStarred;
	TQCheckBox *m_cbCenter, *m_cbBooktabs;
	
	int m_rows;
	int m_cols;
	
	void initEnvironments(bool tabularenv);
	bool isMathmodeEnvironment(const TQString &env);
	
	TQStringList m_alignlist;
	
	TQStringList sortColorTable(TQMap<TQString,char> &colors);
	TQString convertColor(int value);
	char defineColor(const TQString &name, TQMap<TQString,char> &colors, char &colorcode); 	
	TQString getEol(int row,bool top);
};

}

#endif
