/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you wish to add, delete or rename functions or slots use
** TQt Designer which will update this file, preserving your code. Create an
** init() function in place of a constructor, and a destroy() function in
** place of a destructor.
*****************************************************************************/

void NewToolWizard::init()
{
	m_toolList = KileTool::toolList(KGlobal::config(), false);

	//setup the Name page (page 0)
	connect(m_leName, TQT_SIGNAL(textChanged(const TQString &)), this, TQT_SLOT(nameChanged(const TQString &)));
	setNextEnabled(page(0), false);
	setFinishEnabled(page(0), false);
	setHelpEnabled(page(0), false);

	//setup the Behavior page (page 1)
	m_cbTools->insertItem(customTool());
	m_cbTools->insertStringList(m_toolList);
	setFinishEnabled(page(1), true);
	setHelpEnabled(page(1), false);
}

void NewToolWizard::showPage(TQWidget *pg)
{
    	TQWizard::showPage(pg);

	if ( pg == page(0) )
		m_leName->setFocus();
	else if ( pg == page(1) )
		m_cbTools->setFocus();
}

TQString NewToolWizard::customTool()
{
	return i18n("<Custom>");
}

TQString NewToolWizard::toolName()
{
	return m_leName->text();
}

TQString NewToolWizard::parentTool()
{
	return m_cbTools->currentText();
}

void NewToolWizard::nameChanged(const TQString &name)
{
	static TQRegExp reBracket = TQRegExp("\\(|\\)|\\[|\\]");
	bool ok = true;

	if (m_toolList.contains(name))
	{
		m_lbWarning->setText(i18n( "Error: A tool by this name already exists." ));
		ok = false;
	}
	else if (name.find("/") != -1)
	{
		m_lbWarning->setText(i18n( "Error: The name may not contain a slash '/'." ));
		ok = false;
	}
	else if ( name.find(reBracket) != -1 )
	{
		m_lbWarning->setText(i18n("Error: The name may not contain a (,),[ or ]."));
		ok = false;
	}
	else m_lbWarning->setText("");
	setNextEnabled(page(0), ok);
}
