/***************************************************************************
    begin                : Tue Nov 25 2003
    copyright            : (C) 2003 by Jeroen Wijnhout
    email                : Jeroen.Wijnhout@kdemail.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ****************************************************************************/

#ifndef KILETOOLMANAGER_H
#define KILETOOLMANAGER_H

#include <tqobject.h>
#include <tqstringlist.h>
#include <tqptrqueue.h>

#include "kiletool.h"

class TQTimer;
class TQWidgetStack;

class KConfig;
class KTextEdit;
class KAction;
namespace KParts { class PartManager; }

class KileInfo;
namespace KileWidget { class LogMsg; class Output; }

namespace KileTool
{
	class Factory;

	class QueueItem
	{
	public:
		QueueItem(Base *tool, const TQString & cfg = TQString(), bool block = false);
		~QueueItem();

		Base* tool() const { return m_tool; }
		const TQString cfg() const { return m_cfg; }
		bool shouldBlock() { return m_bBlock; }

	private:
		Base	*m_tool;
		TQString	m_cfg;
		bool		m_bBlock;
	};

	class Queue : public TQPtrQueue<QueueItem>
	{
	public:
		Base* tool() const;
		const TQString cfg() const;
		bool shouldBlock() const;

		void enqueueNext(QueueItem *);
	};
	
	class Manager : public TQObject
	{
		Q_OBJECT
  TQ_OBJECT
		
	public:
		Manager(KileInfo *ki, KConfig *config, KileWidget::LogMsg *log, KileWidget::Output *output, KParts::PartManager *, TQWidgetStack *, KAction *, uint to);
		~Manager();

	public:
		void initTool(Base*);
		bool configure(Base*, const TQString & cfg = TQString());
		bool retrieveEntryMap(const TQString & name, Config & map, bool usequeue = true, bool useproject = true, const TQString & cfg = TQString());
		void saveEntryMap(const TQString & name, Config & map, bool usequeue = true, bool useproject = true);
		TQString currentGroup(const TQString &name, bool usequeue = true, bool useproject = true);

		void wantGUIState(const TQString &);
		
		KParts::PartManager * partManager() { return m_pm; }
		TQWidgetStack * widgetStack() { return m_stack; }
		
		KileInfo * info() { return m_ki; }
		KConfig * config() { return m_config; }
		
		void setFactory(Factory* fac) { m_factory = fac; }
		Factory* factory() { return m_factory; }

		bool queryContinue(const TQString & question, const TQString & caption = TQString());

		bool shouldBlock();
		int lastResult() { return m_nLastResult; }

	public slots:
		void started(Base*);
		void done(Base *, int);

		int run(const TQString &, const TQString & = TQString(), bool insertAtTop = false, bool block = false);
		int run(Base *, const TQString & = TQString(), bool insertAtTop = false, bool block = false);

		int runNext(const TQString &, const TQString & = TQString(), bool block = false);
		int runNext(Base *, const TQString & = TQString(), bool block = false);

		int runBlocking(const TQString &, const TQString & = TQString(), bool = false);
		int runNextBlocking(const TQString &, const TQString & = TQString());

		void stop(); //should be a slot that stops the active tool and clears the queue

	private slots:
		int runNextInQueue();
		void enableClear();

	signals:
		void requestGUIState(const TQString &);
		void requestSaveAll(bool, bool);
		void jumpToFirstError();
		void toolStarted();
		void previewDone();

	private:
		KileInfo		*m_ki;
		KConfig		*m_config;
		KileWidget::LogMsg		*m_log;
		KileWidget::Output		*m_output;
		KParts::PartManager	*m_pm;
		TQWidgetStack 			*m_stack;
		KAction				*m_stop;
		Factory				*m_factory;
		Queue				m_queue;
		TQTimer				*m_timer;
		bool					m_bClear;
		int					m_nLastResult;
		uint					m_nTimeout;
	};

	TQStringList toolList(KConfig *config, bool menuOnly = false);
	TQStringList configNames(const TQString &tool, KConfig *config);

	TQString configName(const TQString & tool, KConfig *);
	void setConfigName(const TQString & tool, const TQString & name, KConfig *);

	TQString groupFor(const TQString & tool, KConfig *);
	TQString groupFor(const TQString & tool, const TQString & cfg = "Default" );

	void extract(const TQString &str, TQString &tool, TQString &cfg);
	TQString format(const TQString & tool, const TQString &cfg);

	TQString menuFor(const TQString &tool, KConfig *config);
	TQString iconFor(const TQString &tool, KConfig *config);

	TQString categoryFor(const TQString &clss);

	void setGUIOptions(const TQString &tool, const TQString &menu, const TQString &icon, KConfig *config);
}

#endif
