/***************************************************************************
    begin                : Sun Aug 3 2003
    copyright            : (C) 2003 by Jeroen Wijnhout
    email                : Jeroen.Wijnhout@kdemail.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KILEPROJECTDLGS_H
#define KILEPROJECTDLGS_H

#include <tqcheckbox.h>
#include <tqlayout.h>
#include <tqvgroupbox.h>

#include <kdialogbase.h>
#include <klineedit.h>
#include <kpushbutton.h>

#include "kileproject.h"
#include "templates.h"

class TemplateIconView;
class TQLabel;
class KileProject;
class KComboBox;
class TQVGroupBox;
class TemplateItem;

namespace KileDocument { class Extensions; }
namespace KileTemplate { class Manager; }

class KileProjectDlgBase : public KDialogBase
{
	Q_OBJECT
  TQ_OBJECT

public:
	KileProjectDlgBase(const TQString &caption, KileDocument::Extensions *extensions, TQWidget *parent = 0, const char * name = 0);
	virtual ~KileProjectDlgBase();

	void setProject(KileProject *project, bool override);
	virtual KileProject* project();

	void setProjectTitle(const TQString &title) { m_title->setText(title); }
	const TQString projectTitle() { return m_title->text(); }

	void setExtensions(KileProjectItem::Type type, const TQString & ext);
	const TQString extensions(KileProjectItem::Type type)
		{ return m_val_extensions[type-1]; }

protected slots:
	virtual void slotOk() = 0;
	virtual void fillProjectDefaults();

private slots:
	void slotExtensionsHighlighted(int index);
	void slotExtensionsTextChanged(const TQString &text);

protected:
	KileDocument::Extensions *m_extmanager;

	TQVGroupBox *m_pgroup, *m_egroup;
	TQGridLayout	*m_pgrid, *m_egrid;
	TQLabel *m_plabel;

	KLineEdit	*m_title, *m_extensions;
	TQLabel *m_lbPredefinedExtensions, *m_lbStandardExtensions;
	KileProject	*m_project;
	KComboBox	*m_sel_extensions;

	TQString		m_val_extensions[KileProjectItem::Other - 1];
	TQString 		m_val_standardExtensions[KileProjectItem::Other - 1];

	bool acceptUserExtensions();

};

class KileNewProjectDlg : public KileProjectDlgBase
{
	Q_OBJECT
  TQ_OBJECT

public:
	KileNewProjectDlg(KileTemplate::Manager *templateManager, KileDocument::Extensions *extensions, TQWidget* parent = 0, const char* name = 0);
	~KileNewProjectDlg();

	KileProject* project();

	TQString bare();
	TQString location() { return m_location->text(); }

	TemplateItem* getSelection() const;
	TQString file() { return m_file->text();}
	bool createNewFile() { return m_cb->isChecked(); }

private slots:
	void clickedCreateNewFileCb();
	void browseLocation();
	void makeProjectPath();
	void slotOk();
	void fillProjectDefaults();

private:
	KileTemplate::Manager	*m_templateManager;
	KLineEdit		*m_location, *m_file, *m_name;
	TemplateIconView	*m_templateIconView;
	TQCheckBox		*m_cb;
	TQLabel 			*m_lb;

	KPushButton *m_pbChooseDir;
	TQString			m_dir, m_filename;
};

class KileProjectOptionsDlg : public KileProjectDlgBase
{
	Q_OBJECT
  TQ_OBJECT

public:
	KileProjectOptionsDlg(KileProject *project, KileDocument::Extensions *extensions, TQWidget *parent = 0, const char * name = 0);
	~KileProjectOptionsDlg();

private slots:
	void slotOk();
	void toggleMakeIndex(bool);

private:
	KComboBox	*m_master, *m_cbQuick;
	KLineEdit		*m_leMakeIndex;
	TQCheckBox	*m_ckMakeIndex;
};

#endif
