//
// C++ Interface: kileeventfilter
//
// Description: 
//
//
// Author: Jeroen Wijnhout <Jeroen.Wijnhout@kdemail.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KILEEVENTFILTER_H
#define KILEEVENTFILTER_H

#include <tqobject.h>
#include <tqregexp.h>

class TQEvent;

namespace Kate {class View; }
namespace KileDocument { class EditorExtension; };

/**
 * This class is capable of intercepting key-strokes from the editor. It can complete a \begin{env}
 * with a \end{env} when enter is pressed.
 **/
class KileEventFilter : public TQObject
{
	Q_OBJECT
  TQ_OBJECT

public:
	KileEventFilter(KileDocument::EditorExtension *edit);

public slots:
	void readConfig();

protected:
	bool eventFilter(TQObject *o, TQEvent *e);

private:
	bool    m_bCompleteEnvironment;
	KileDocument::EditorExtension *m_edit;

};

#endif
