/***************************************************************************
    date                 : Nov 02 2005
    version              : 0.23
    copyright            : (C) 2004-2005 by Holger Danielsson, 2004 Jeroen Wijnhout
    email                : holger.danielsson@t-online.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef INCLUDEGRAPHICSDIALOG_H
#define INCLUDEGRAPHICSDIALOG_H

#include <tqstring.h>

#include <kdialogbase.h>

/**
  *@author dani 
  */

class TQLabel;
class TQCheckBox;

class KileInfo;
class KLineEdit;
class KProcess;
class KShellProcess;

namespace KileDialog
{

class IncludeGraphics : public KDialogBase
{
	Q_OBJECT
  TQ_OBJECT

public:
	IncludeGraphics(TQWidget *parent,const TQString &startdir,KileInfo *ki);
	~IncludeGraphics();

	TQString getTemplate();
	TQString getFilename();

private slots:
	void chooseFile();
	void updateFigure();

	void slotProcessOutput(KProcess* proc,char* buffer,int buflen);
	void slotProcessExited(KProcess* proc);

	void slotOk();

private:
	void readConfig();
	void writeConfig();
	bool checkParameter();
	TQString getOptions();
	TQString getInfo();
	bool getPictureSize(int &wpx, int &hpx, TQString &dpi, TQString &wcm, TQString &hcm);
	void setInfo();

	TQLabel *infolabel;
	KLineEdit *edit_file, *edit_label, *edit_caption, *edit_width, *edit_height, *edit_angle, *edit_bb;
	TQCheckBox *cb_center, *cb_pdftex, *cb_figure, *cb_graphicspath;
	TQLabel *lb_label, *lb_caption;

	TQString m_startdir;  
	TQString m_output;

	// current picture
	int m_width,m_height;
	float m_resolution;

	// default
	bool m_imagemagick;
	bool m_boundingbox;
	float m_defaultresolution;

	void execute(const TQString &command);
	
	KileInfo *m_ki;
	KShellProcess* m_proc;
};

}

#endif
