/***************************************************************************
    date                 : Feb 09 2004
    version              : 0.10.0
    copyright            : (C) 2004 by Holger Danielsson
    email                : holger.danielsson@t-online.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CONFIGSTRUCTURE_H
#define CONFIGSTRUCTURE_H

#include <tqwidget.h>
#include <tqtable.h>
#include <tqstring.h>
#include <tqstringlist.h>
#include <tqmap.h>

class KConfig;

class TQRect;
class TQPainter;
class TQSpinBox;
class TQComboBox;
class TQPushButton;

/**
  *@author Holger Danielsson
  */

namespace KileStructure
{

  enum  { None=0x0, Visible=0x1, Opened=0x2 };
  
class KileCenteredTableItem : public TQTableItem
{
public:
   KileCenteredTableItem(TQTable *table,EditType et,const TQString& text) : TQTableItem(table,et,text) {}
   void paint(TQPainter* p,const TQColorGroup& cg,const TQRect& cr,bool selected);  
   int alignment() const { return TQt::AlignHCenter; } 
};

class KileTable : public TQTable
{
   Q_OBJECT
  TQ_OBJECT
public:
   KileTable(TQWidget *dialog, TQWidget *parent=0, const char *name=0);
   void paintFocus(TQPainter *, const TQRect &) {}
protected:
   void contentsMousePressEvent(TQMouseEvent *ev);
signals:
   void clickedCell(KileTable *,int row,int cell);
};


class ConfigStructure : public TQWidget
{
    Q_OBJECT
  TQ_OBJECT
public: 
   ConfigStructure(TQWidget *parent=0, const char *name=0);
   ~ConfigStructure();

   void readConfig(KConfig *config);
   void writeConfig(KConfig *config);

private:
   TQStringList m_entries;
   TQComboBox *comboclasses;
   TQSpinBox *m_structurelevel;
   TQPushButton *add, *remove;

   KileTable *m_entriestable,*m_sectioningtable;
   TQCheckTableItem *m_visible[6], *m_defaultopen[6];
   TQMap<TQString,const TQStringList *> m_docclasses;

   void showSectioning(const TQStringList *list);
   void changeSectioning(const TQStringList *list);

public slots:
   void polish();

private slots:
  void clickedTable(KileTable *table,int row,int col);
  void clickedAdd();
  void spinboxChanged(int);
  void comboboxChanged(const TQString &name);
};

}
#endif
