/*****************************************************************

   Copyright (c) 2006 Stephan Binner <binner@kde.org>
   Copyright (C) 2006 Debajyoti Bera <dbera.web@gmail.com>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.

******************************************************************/

#ifndef __STATUS_H__
#define __STATUS_H__

#include <tqlabel.h>
#include <tqgroupbox.h>
#include <tqtextedit.h>
#include <kcmodule.h>
#include <kpushbutton.h>

class KCMBeagleStatus : public KCModule
{
  Q_OBJECT
  TQ_OBJECT

public:
  KCMBeagleStatus(TQWidget *parent=0, const char *name=0);
  ~KCMBeagleStatus();

  virtual void load();
  virtual void load( bool useDefaults );
  virtual void save();
  virtual void defaults();

private slots:
  void refreshStatus ();
  void controlPressed ();
  void verifyStatus ();

private:
  bool refreshDaemonStatus ();
  bool stopBeagle ();
  bool startBeagle ();

  TQLabel *label_control;
  KPushButton *pb_control, *pb_refresh;
  TQLabel *version_label;
  TQTextEdit *status_area, *index_info_box;
  TQGroupBox *status_box;
  bool last_status;
};

#endif
