/*****************************************************************

   Copyright (c) 2006 Stephan Binner <binner@kde.org>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.

******************************************************************/

#include <tqlayout.h>
#include <tqtabwidget.h>
#include <kdebug.h>
#include <kdialog.h>
#include <klocale.h>
#include <kprocess.h>

#include "beagle.h"
#include "indexing.h"
#include "backends.h"
#include "status.h"

KCMBeagle::KCMBeagle(TQWidget *parent, const char *name)
    : KCModule( parent, "kcmbeagle" ) 
{
  setButtons(Default+Apply);

  TQVBoxLayout *layout = new TQVBoxLayout(this);
  m_tab = new TQTabWidget(this);
  layout->addWidget(m_tab);

  m_indexing = new KCMBeagleIndexing( m_tab, name );
  m_indexing->layout()->setMargin( KDialog::marginHint() );

  m_backends = new KCMBeagleBackends( m_tab, name );
  m_backends->layout()->setMargin( KDialog::marginHint() );

  m_status = new KCMBeagleStatus( m_tab, name );
  m_status->layout()->setMargin( KDialog::marginHint() );

  m_tab->addTab(m_indexing, i18n("&Indexing"));
  m_tab->addTab(m_backends, i18n("&Backends"));
  m_tab->addTab(m_status, i18n("&Daemon Status"));

  connect(m_indexing, TQT_SIGNAL(changed(bool)), TQT_SIGNAL(changed(bool)));
  connect(m_backends, TQT_SIGNAL(changed(bool)), TQT_SIGNAL(changed(bool)));
  connect(m_status, TQT_SIGNAL(changed(bool)), TQT_SIGNAL(changed(bool)));
  connect(m_tab, TQT_SIGNAL(currentChanged(TQWidget *)), TQT_SIGNAL(quickHelpChanged()));
}

void KCMBeagle::load()
{
  m_indexing->load();
  m_backends->load();
  m_status->load();
}

void KCMBeagle::defaults()
{
  m_indexing->defaults();
  m_backends->defaults();
  m_status->defaults();
}

void KCMBeagle::save()
{
  m_indexing->save();
  m_backends->save();
  m_status->save();

  KProcess *proc = new KProcess;
  *proc << "beagle-config";
  *proc << "--beagled-reload-config";
  if (!proc->start())
    kdError("Could not make Beagle reload its config.");
}

TQString KCMBeagle::quickHelp() const
{
  TQWidget *w = m_tab->currentPage();
  if (w->inherits("KCModule"))
  {
     KCModule *m = static_cast<KCModule *>(w);
     return m->quickHelp();
  }
  return TQString();
}

#include "beagle.moc"
