/***************************************************************************
 *   Copyright (C) 2005 by Debajyoti Bera <dbera.web@gmail.com>            *
 *   Copyright (C) 2005 Novell, Inc.                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA           *
 ***************************************************************************/

#ifndef BEAGLESEARCH_H
#define BEAGLESEARCH_H

#include <tqobject.h>
#include <tqthread.h>
#include <tqstringlist.h>
#include <tqregexp.h>
#include <tqmutex.h>

extern "C" {
#include <glib.h>
#include <beagle/beagle.h>
#include <beagle/beagle-query-part-property.h>
}

#define RESULTFOUND (TQEvent::Type)1001 /* TQEvent::User + 1 */
#define RESULTGONE  (TQEvent::Type)1002 /* TQEvent::User + 2 */
#define SEARCHOVER  (TQEvent::Type)1003 /* TQEvent::User + 3 */
#define KILLME      (TQEvent::Type)1004 /* TQEvent::User + 4 */

/**
  Interface to beagle-query
*/
class BeagleSearch : public TQThread {

public:

enum TileGroup {
	Application=1, 	// in scope list
	Contact,
	Folder,
	Documents,  	// in scope list
	Conversations,  // in scope list
	Image,  	// in scope list
	Audio,  	// in scope list
	Video,  	// in scope list
	Website,        // in scope list
	Feed,
	Note,
	Packages,
	Unknown
};

typedef TQValueList<TQString> PropertyList;

class beagle_result_struct {
public:
        beagle_result_struct () {
                uri = NULL;
                parent_uri = NULL;
                source = NULL;
                mime_type = NULL;
                snippet = NULL;
                last_index_time = 0;
                show_expanded = false;
        }       
        
        ~beagle_result_struct () {
                delete uri;
                delete parent_uri;
                delete source;
                delete mime_type;
                delete snippet;
        }       
        
        TQString         *uri;
        TQString         *parent_uri;
        TQString         *source;
        PropertyList    properties;
        TQString         hit_type;
        TQString         *mime_type;
        time_t          last_index_time;
        double          score;
        TQString         *snippet;
        TileGroup       tilegroup;
        int             client_id;
        bool            show_expanded;
};

typedef TQPtrList<beagle_result_struct> BeagleResultList;

typedef TQValueList<TQString> VanishedURIList;

class BeagleVanishedURIList {
public:
        BeagleVanishedURIList() {
                client_id = 0;
        }

        ~BeagleVanishedURIList () {}

        int             client_id;
	VanishedURIList list;
};

    BeagleSearch(int id, TQObject *parent, TQString term);
    ~BeagleSearch();

    virtual void run();

    void stopClient();

    int id;
    bool kill_me;

private:
	TQObject	       *parent;

	static void hits_added_cb (BeagleQuery *, BeagleHitsAddedResponse *, BeagleSearch* client);
	static void hits_subtracted_cb (BeagleQuery *, BeagleHitsSubtractedResponse *, BeagleSearch* client);
	static void finished_cb (BeagleQuery *, BeagleFinishedResponse *, BeagleSearch* client);

	static TQString *get_uri_from_feed_hit (BeagleHit *);
	static TQString *get_uri_from_file_hit (BeagleHit *);
	static TQString *get_parent_uri_from_file_hit (BeagleHit *);
	static TQString *get_source_from_file_hit (BeagleHit *);

	TQMutex *client_mutex;

	BeagleClient   *client;
	BeagleQuery    *query;
	GMainLoop      *main_loop;
};

#endif
