/* This file is part of the Keep project
   Copyright (C) 2005 Jean-Rémy Falleri <jr.falleri@laposte.net>

   Keep is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   Keep is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Keep; if not, write to the
   Free Software Foundation, Inc.,
   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.           */

#ifndef _RESTOREBACKUPWIZARD_H_ 
#define _RESTOREBACKUPWIZARD_H_ 

#include <kwizard.h>
#include <kpopupmenu.h>
#include <tqhbox.h>
#include <tqlistview.h>

#include "restorebackupwizard1view.h"
#include "restorebackupwizard2view.h"
#include "restorebackupwizard3view.h"
#include "backup.h"
#include "rdbmanager.h"

class RestoreBackupWizard: public KWizard
{
Q_OBJECT
  TQ_OBJECT
public:
	RestoreBackupWizard(TQWidget *parent, const char *name);
	~RestoreBackupWizard();

	Backup backup();
	void setBackup(Backup backup);

protected slots:
	void slotContextMenu(KListView *list,TQListViewItem * item,const TQPoint &point);
	void slotPage1Changed();
	void slotPage2Changed();
	void slotPage3Changed();

	void slotCustomSourceChecked(bool value);

	void slotShowDiff();
	void slotShowChanged();
	void slotShowList();

	void slotRestoreBackup();
	void slotRestoreError(Backup backup,TQString errorMessage);

private:
	// init GUI
	void setupPage1();
	void setupPage2();
	void setupPage3();
	void initConnections();
	
	KPopupMenu *m_popup;
	TQHBox *page1,*page2,*page3;
	RestoreBackupWizard1View *restoreBackupWizard1View ;
	RestoreBackupWizard2View *restoreBackupWizard2View;
	RestoreBackupWizard3View *restoreBackupWizard3View;
	Backup m_backup;
	RDBManager *m_manager;
};

#endif
