/* This file is part of the Keep project
   Copyright (C) 2006 Jean-Rémy Falleri <jr.falleri@laposte.net>

   Keep is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   Keep is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Keep; if not, write to the
   Free Software Foundation, Inc.,
   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.           */

#include "includeexcludedialog.h"

#include <klocale.h>
#include <tqlayout.h>
#include <kurl.h>
#include <dcopref.h>
#include <kdebug.h>
#include <kactivelabel.h>
#include <kmimetype.h>
#include <tqpixmap.h>
#include <kapplication.h>
#include <kpushbutton.h>
#include <kiconloader.h>
#include <tqstringlist.h>
#include <kactionselector.h>
#include <klistview.h>
#include <kurlrequester.h>

#include "includeexcludeitem.h"

IncludeExcludeDialog::IncludeExcludeDialog(TQWidget *parent):KDialogBase(Plain, i18n("Inclusion/Exclusion Configuration"),
	Help|Ok, Ok, parent, "includeExcludeDialog", true, false)
{
	TQGridLayout *topLayout = new TQGridLayout(plainPage());
	m_view = new IncludeExcludeView(plainPage());

	topLayout->addWidget( m_view,0,0 );

	KIconLoader *icons = KGlobal::iconLoader();
	m_view->remove->setPixmap(icons->loadIcon("remove",KIcon::Toolbar,22));

	m_view->includeExcludeList->setSorting(-1);

	connect(m_view->include,TQT_SIGNAL(clicked()),this,TQT_SLOT(slotInclude()));
	connect(m_view->exclude,TQT_SIGNAL(clicked()),this,TQT_SLOT(slotExclude()));
	connect(m_view->remove,TQT_SIGNAL(clicked()),this,TQT_SLOT(slotRemove()));

	resize( TQSize(450,450).expandedTo(minimumSizeHint()) );
}

TQStringList IncludeExcludeDialog::includeExcludeList()
{
	TQStringList includeExcludeList;
	TQListViewItemIterator it( m_view->includeExcludeList );
	while ( it.current() ) {
		TQListViewItem *item = it.current();
		IncludeExcludeItem *includeExcludeItem = static_cast<IncludeExcludeItem*>(item);
		includeExcludeList.append(includeExcludeItem->includeExclude());
		++it;
	}
	return includeExcludeList;
}

void IncludeExcludeDialog::setIncludeExcludeList(TQStringList includeExcludeList)
{
	m_view->includeExcludeList->clear();
	TQStringList::iterator it;
	IncludeExcludeItem *lastItem;
	for ( it = includeExcludeList.begin(); it != includeExcludeList.end(); ++it )
	{
		if ( it == includeExcludeList.begin() )
			lastItem = new IncludeExcludeItem(m_view->includeExcludeList,*it);
		else
		{
			IncludeExcludeItem *item = new IncludeExcludeItem(m_view->includeExcludeList,lastItem,*it);
			lastItem = item;
		}
		
	}
}

void IncludeExcludeDialog::slotInclude()
{
	IncludeExcludeItem *item = new IncludeExcludeItem( m_view->includeExcludeList,"I" + m_view->itemURL->url() );
}

void IncludeExcludeDialog::slotExclude()
{
	IncludeExcludeItem *item = new IncludeExcludeItem( m_view->includeExcludeList,"E" + m_view->itemURL->url() );
}


void IncludeExcludeDialog::slotRemove()
{
	m_view->includeExcludeList->takeItem(m_view->includeExcludeList->selectedItem());
}

#include "includeexcludedialog.moc"
