/* This file is part of the Keep project
   Copyright (C) 2005 Jean-Rémy Falleri <jr.falleri@laposte.net>

   Keep is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   Keep is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Keep; if not, write to the
   Free Software Foundation, Inc.,
   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.           */

#ifndef _ADDBACKUPWIZARD_H_
#define _ADDBACKUPWIZARD_H_

#include <kwizard.h>
#include <tqhbox.h>

#include "backup.h"
#include "advancedbackupconfigdialog.h"
#include "includeexcludedialog.h"
#include "addbackupwizard1view.h"
#include "addbackupwizard2view.h"
#include "addbackupwizard3view.h"

class AddBackupWizard: public KWizard
{
Q_OBJECT
  TQ_OBJECT
public:
	AddBackupWizard(TQWidget *parent, const char *name);
	AddBackupWizard(Backup backup,TQWidget *parent, const char *name);

	Backup backup();

public slots:
	void slotPage1Changed();
	void slotPage2Changed();

	void slotShowAdvancedConfig();
	void slotShowIncludeExclude();
	void slotFinishClicked();

signals:
	void backupSetted(Backup backup);

private:
	// init GUI
	void setupPage1();
	void setupPage2();
	void setupPage3();

	void initView();
	void initConnections();

	TQHBox *page1,*page2,*page3;
	AddBackupWizard1View *addBackupWizard1View;
	AddBackupWizard2View *addBackupWizard2View;
	AddBackupWizard3View *addBackupWizard3View;
	AdvancedBackupConfigDialog *advancedBackupConfigDialog;
	IncludeExcludeDialog *includeExcludeDialog;
};

#endif
