/***************************************************************************
 *   Copyright (C) 2005-2007 by Stephen Leaf <smileaf@gmail.com>           *
 *   Copyright (C) 2006 by Oswald Buddenhagen <ossi@kde.org>               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.          *
 ***************************************************************************/

#ifndef _KDMTHEME_H_
#define _KDMTHEME_H_

#include <kconfig.h>
#include <kcmodule.h>

#include <tqwidget.h>

class ThemeData;

class TQLabel;
class TQPushButton;
class TQListView;
class TQCheckBox;

class KDMThemeWidget : public KCModule {
	Q_OBJECT
  TQ_OBJECT

  public:
	KDMThemeWidget( TQWidget *parent = 0, const char *name=0, const TQStringList& = TQStringList() );

	virtual void load();
	virtual void save();
	virtual void defaults();
	void setReadOnly( bool );

  private:
	void selectTheme( const TQString & );
	void insertTheme( const TQString & );
	void updateInfoView( ThemeData * );

	TQListView *themeWidget;
	TQLabel *preview;
	TQLabel *info;
	TQPushButton *bInstallTheme;
	TQPushButton *bRemoveTheme;
	TQCheckBox *cUseTheme;
	TQLabel *sakWarning;

	ThemeData *defaultTheme;
	TQString themeDir;
	KConfig *config;

  protected slots:
	void themeSelected();
	void removeSelectedThemes();
	void installNewTheme();
	void toggleUseTheme(bool);

};

#endif
