/***************************************************************************
 *   Copyright (C) 2006-2007 by Rajko Albrecht                             *
 *   ral@alwins-world.de                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.         *
 ***************************************************************************/
#ifndef REVTREEWIDGET_H
#define REVTREEWIDGET_H

#include <svnqt/revision.hpp>

#include <tqvariant.h>
#include <tqpixmap.h>
#include <tqwidget.h>

class TQVBoxLayout;
class TQHBoxLayout;
class TQGridLayout;
class TQSpacerItem;
class RevGraphView;
class TQSplitter;
class KTextBrowser;
class CContextListener;

namespace svn {
    class LogEntry;
    class Client;
}

class RevTreeWidget : public TQWidget
{
    Q_OBJECT
  TQ_OBJECT

public:
    RevTreeWidget(TQObject*,svn::Client*,TQWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
    ~RevTreeWidget();

    TQSplitter* m_Splitter;
    RevGraphView* m_RevGraphView;

    void setBasePath(const TQString&);
    void dumpRevtree();

protected:
    TQVBoxLayout* RevTreeWidgetLayout;
    KTextBrowser* m_Detailstext;

signals:
    void makeCat(const svn::Revision&,const TQString&,const TQString&,const svn::Revision&,TQWidget*);
    void makeNorecDiff(const TQString&,const svn::Revision&,const TQString&,const svn::Revision&,TQWidget*);
    void makeRecDiff(const TQString&,const svn::Revision&,const TQString&,const svn::Revision&,TQWidget*);

protected slots:
    virtual void setDetailText(const TQString&);

private:
    TQPixmap image0;

};

#endif // REVTREEWIDGET_H
