/***************************************************************************
 *   Copyright (C) 2004-2007 by Georgy Yunaev, gyunaev@ulduzsoft.com       *
 *   Please do not use email address above for bug reports; see            *
 *   the README file                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#include <tqcstring.h>
#include <tqimage.h>
#include <tqdir.h>

#include "libchmfile.h"
#include "libchmurlfactory.h"

#include "kchmmainwindow.h"
#include "kchmviewwindow.h"
#include "kchmsourcefactory.h"
#include "kchmviewwindow_qtextbrowser.h"


KCHMSourceFactory::KCHMSourceFactory (KCHMViewWindow * viewwindow)
	: TQMimeSourceFactory()
{
	m_viewWindow = viewwindow;
}


const TQMimeSource * KCHMSourceFactory::data( const TQString & abs_name ) const
{
	TQString data, file, path = abs_name;

	// Retreive the data from chm file
	 LCHMFile * chm = ::mainWindow->chmFile();

	if ( !chm )
		return 0;

	int pos = path.find ('#');
	if ( pos != -1 )
		path = path.left (pos);
	
	// To handle a single-image pages, we need to generate the HTML page to show 
	// this image. We did it in KCHMViewWindow::handleStartPageAsImage; now we need
	// to generate the HTML page, and set it.
	if ( LCHMUrlFactory::handleFileType( path, data ) )
	{
		((TQMimeSourceFactory*)this)->setText (path, data);
	}
	else if ( path.endsWith (".htm") || path.endsWith (".html") )
	{
		if ( chm->getFileContentAsString( &data, path ) )
			((TQMimeSourceFactory*)this)->setText (path, data);
	}
	else
	{
		// treat as image
		TQImage img;
		TQByteArray buf;
		
		TQString fpath = KCHMViewWindow_QTextBrowser::decodeUrl( path );
		
		if ( chm->getFileContentAsBinary( &buf, fpath ) )
		{
			if ( img.loadFromData ( (const uchar *) buf.data(), buf.size() ) )
				((TQMimeSourceFactory*)this)->setImage (path, img);
		}
		else
		{
			((TQMimeSourceFactory*)this)->setImage( path, img );
			qWarning( "Could not resolve file %s\n", path.ascii() );
		}
	}
	
	return TQMimeSourceFactory::data (path);
}

TQString KCHMSourceFactory::makeAbsolute ( const TQString & abs_or_rel_name, const TQString & ) const
{
	return m_viewWindow->makeURLabsolute ( abs_or_rel_name, false );
}
