/***************************************************************************
 *   Copyright (C) 2004-2007 by Georgy Yunaev, gyunaev@ulduzsoft.com       *
 *   Please do not use email address above for bug reports; see            *
 *   the README file                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#ifndef KCHMINDEXWINDOW_H
#define KCHMINDEXWINDOW_H


#include <tqlineedit.h>
#include <tqlistview.h>


/**
@author Georgy Yunaev
*/
class KCHMIndexWindow : public TQWidget
{
	Q_OBJECT
  TQ_OBJECT
	public:
		KCHMIndexWindow ( TQWidget * parent = 0, const char * name = 0, WFlags f = 0 );
	
		void	invalidate();
		void	search( const TQString& index );
		
	public slots:
		void	slotContextMenuRequested ( TQListViewItem *item, const TQPoint &point, int column );
			
	private slots:
		void 	onTextChanged ( const TQString & newvalue);
		void 	onReturnPressed ();
		void	onDoubleClicked ( TQListViewItem *, const TQPoint &, int);
	
	private:
		virtual void showEvent ( TQShowEvent * );
		
		void	refillIndex();
		
		TQLineEdit 	*	m_indexFinder;
		KQListView	*	m_indexList;
		KTQPopupMenu * 	m_contextMenu;	
		TQListViewItem * m_lastSelectedItem;
		bool			m_indexListFilled;
};

#endif
