/***************************************************************************
 *   Copyright (C) 2004-2005 by Georgy Yunaev, gyunaev@ulduzsoft.com       *
 *   Please do not use email address above for bug reports; see            *
 *   the README file                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#ifndef MSITS_H
#define MSITS_H


#include <kio/slavebase.h>
#include <kurl.h>

#include <tqstring.h>
#include <tqcstring.h>

#include "config.h"
#include "chm_lib.h"


class ProtocolMSITS : public KIO::SlaveBase
{
public:
    ProtocolMSITS ( const TQCString&, const TQCString& );
    virtual ~ProtocolMSITS();

    virtual void	get ( const KURL& );
	virtual void	listDir (const KURL & url);
	virtual void	stat (const KURL & url);

private:
	// This function does next thing:
	// - parses the URL to get a file name and URL inside the file;
	// - loads a new CHM file, if needed;
	// - returns the parsed URL inside the file;
	bool	parseLoadAndLookup ( const KURL&, TQString& abspath );

	// Resolve an object inside a CHM file
	inline bool ResolveObject (const TQString& fileName, chmUnitInfo *ui)
	{
		return m_chmFile != NULL && ::chm_resolve_object(m_chmFile, fileName.utf8(), ui) == CHM_RESOLVE_SUCCESS;
	}

	// Retrieve an object from the CHM file
	inline size_t RetrieveObject (const chmUnitInfo *ui, unsigned char *buffer, LONGUINT64 fileOffset, LONGINT64 bufferSize)
	{
#if USE_BUILTIN_CHMLIB
		return ::chm_retrieve_object(m_chmFile, ui, buffer, 
			fileOffset, bufferSize);
#else
		return ::chm_retrieve_object(m_chmFile, const_cast<chmUnitInfo*>(ui),
			buffer, fileOffset, bufferSize);
#endif
	}

	// An opened file name, if presend
    TQString         m_openedFile;

	// a CHM structure file pointer (from chmlib)
	chmFile		*	m_chmFile;
};


#endif /* MSITS_H */
