/***************************************************************************
 *   Copyright (C) 2005 by Alexander Nemish   *
 *   atlanter@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include <kapplication.h>
#include <dcopclient.h>
#include <tqdatastream.h>
#include <tqstring.h>

int main(int argc, char **argv)
{
    KApplication app(argc, argv, "bookreader_client", false);

    // get our DCOP client and attach so that we may use it
    DCOPClient *client = app.dcopClient();
    client->attach();

    // do a 'send' for now
    TQByteArray data;
    TQDataStream ds(data, IO_WriteOnly);
    if (argc > 1)
        ds << TQString(argv[1]);
    else
        ds << TQString("http://www.kde.org");
    client->send("bookreader", "BookReaderIface", "openURL(TQString)", data);

    return app.exec();
}
