/*
 *   Copyright (C) 2006
 *   Siraj Razick <siraj@kdemail.net>
 *   PhobosK <phobosk@mail.kbfx.org>
 *   see Also AUTHORS
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU Library General Public License version 2 as
 *   published by the Free Software Foundation
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifndef KBFX_PLASMA_CANVAS_ITEM_H
#define KBFX_PLASMA_CANVAS_ITEM_H

#include <tqcanvas.h>
#include <tqfont.h>
#include <tqfontinfo.h>
#include <tqimage.h>

#include <kapplication.h>
#include <kdebug.h>
#include <kdesktopfile.h>

#include <kbfxconfig.h>
#include <kbfxplasmapixmapprovider.h>

#include "kbfxplasmacanvasabstractitem.h"


class KbfxPlasmaCanvasItem:public KbfxPlasmaCanvasAbstractItem
{

		Q_OBJECT
  TQ_OBJECT

	public:

//		typedef enum {EXECUTABLE=0,SEPARATOR,INDEX,OTHER} Type;
		typedef enum {RASTER=0,VECTOR,NATIVE} SkinMode;


		KbfxPlasmaCanvasItem ( TQCanvasPixmapArray * a, TQCanvas * canvas );
		KbfxPlasmaCanvasItem ( const KbfxPlasmaCanvasItem &t );
		KbfxPlasmaCanvasItem &operator = ( const KbfxPlasmaCanvasItem &t );
		virtual ~KbfxPlasmaCanvasItem ();

		bool itemMode();
		void setItemMode ( bool mode=true );
		void setType ( Type );
		void setCurrent ( bool );
		void setExec ( TQString desktopfile );
		TQString name() {return m_labelText;};
		TQString desktopFile() { return m_desktopFilePath;}


		KbfxDataSource * source() { return m_source;}
		void setSource ( KbfxDataSource src );
		void setCommand ( TQString cmd );
		void setComment ( TQString comment );
		void setIcon ( TQPixmap pixmap );
		void setIconPath ( TQString path );
		bool isCurrent();
		int height() { return m_height;}
		int width() { return m_width;}
		Type type() { return m_type;}
		bool lookup ( TQString str );
		virtual void advance ( int phase );
		virtual int  rtti() const { return CANVASITEM;}
		virtual void draw ( TQPainter & pe );
		virtual void drawContent ( TQPainter * pe );
		virtual TQPixmap dragPixmap();

//		virtual void drawText(TQPainter  *pe,TQString str);
		virtual void drawBackDrop ( TQPainter * pe,TQRect & rect );

		/* Event Handling */
		virtual void mousePressEvent ( TQMouseEvent * e );
		virtual void mouseMoveEvent ( TQMouseEvent * e );
		virtual void enterEvent ( TQEvent * e );
		virtual void mouseReleaseEvent ( TQMouseEvent * e );


		void setLabelText ( TQString s );

	public slots:
		void updateAngle() {}
		void hideit();
		void exec();
	signals:
		void leave();
		void selected ( KbfxPlasmaCanvasItem* );

	private:


		void drawStar ( TQPainter * pe );

		int m_frameCount;
		int m_textWidth;
		TQString m_exec;
		TQString m_desktopFilePath;
		TQString m_labelText;
		TQString m_commentText;
		TQPixmap m_icon;
		TQString m_iconPath;
		KDesktopFile  * m_desktopFile;
		KbfxDataSource * m_source;

		/* Theming stuff */
		TQColor m_fontAppNameColor;
		TQFont m_fontAppNameFont;
		TQColor m_commentColor;
		TQFont m_commentFont;
		TQColor m_lineColor;
		TQFont m_sepNameFont;
		bool m_boldFonts;
		bool m_skined;
		bool m_restricted ; //KDE kiosk
		Type  m_type;
		bool m_hidden;
		TQString m_error;
		bool m_isCurrent;
		bool m_noComments;
		int m_margin;
		int m_height;
		int m_width;
		int m_iconSize;
}
;//C.G

#endif //M.I.G

