/*
 *   Copyright (C) 2006
 *   Siraj Razick <siraj@kdemail.net>
 *   PhobosK <phobosk@mail.kbfx.org>
 *   see Also AUTHORS
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU Library General Public License version 2 as
 *   published by the Free Software Foundation
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifndef KBFX_DATA_SOURCE_H
#define KBFX_DATA_SOURCE_H

#include <tqvaluelist.h>
#include <tqstring.h>

class KbfxDataSource
{


	public:
		typedef enum
		{ DESKTOP = 0, NONDESKTOP } Type;
		typedef TQValueList < KbfxDataSource > DataSourceList;
		/**
		 * Constructs a new DataSource. Data source is a simple class that holds
		 * a .desktop file and also you can include a custom commmand that can be 
		 * exectuted 
		 * @return a pointer to a new data source
		 */
		KbfxDataSource ();
		virtual ~ KbfxDataSource ();

		/**
		 * Sets the name of a data source and should not be used if your dara is 
		 *  a desktop file use KbfxDataSource::setDesktopPath() functions instead
		 * @param name should be the name of the data source
		 */
		void setName ( TQString name )
		{
			m_text = name;
		}
		/**
		 * Sets the desktop file of for the data source. Note that u do not have to check 
		 * parameters such as if the the desktop is kiosk allowed. the this function internally 
		 * abstracts such functions.
		 * @param path should be the absolute path of a valid desktop file
		 */
		void setDesktopPath ( TQString path )
		{
			m_desktopPath = path;
			m_type = DESKTOP;
			loadDesktopFile ();
		}

		virtual void setCommand ( TQString cmd )
		{
			m_command = cmd;
		}


		void setContentPath ( TQString path )
		{
			m_contentPath = path;
		}
		TQString contentPath ()
		{
			return m_contentPath;
		}

		virtual void setType ( Type t )
		{
			m_type = t;
		}

		virtual void exec ();

		void setComment ( TQString comment )
		{
			m_comment = comment;
		};

		void setDescription ( TQString desc )
		{
			m_description = desc;
		}

		void setIconPath ( TQString path )
		{
			m_iconPath = path;
		}

		TQString desktopFile ()
		{
			return m_desktopPath;
		}
		//out
		TQString name ()
		{
			return m_text;
		}
		TQString icon ()
		{
			return m_iconPath;
		};
		TQString command ()
		{
			return m_command;
		}
		Type type ()
		{
			return m_type;
		}
		/**
		 * Use this function to get the comment of the a data soruce. this 
		 * functio will NOT return NULL so no checking needed
		 * @return the comment of the data source or empty string 
		 */
		TQString comment ()
		{
			return m_comment;
		}
		bool lookup ( TQString str );
	private:
//TODO
//MOve to private D
		void loadDesktopFile ();
		TQString m_text;
		TQString m_desktopPath;
		TQString m_command;
		TQString m_iconPath;
		TQString m_comment;
		TQString m_description;
		TQString m_keyWords;
		Type m_type;
		TQString m_contentPath;


};
#endif
