/*
 *   Copyright (C) 2006
 *   Siraj Razick <siraj@kdemail.net>
 *   PhobosK <phobosk@mail.kbfx.org>
 *   see Also AUTHORS
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU Library General Public License version 2 as
 *   published by the Free Software Foundation
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifndef KBFX_DATA_GROUP_LIST_H
#define KBFX_DATA_GROUP_LIST_H

#include <tqptrlist.h>
#include "kbfxdatagroup.h"

class KbfxDataGroupList
{
	public:
		typedef TQPtrList<KbfxDataGroup> GroupList;
		KbfxDataGroupList();
		~KbfxDataGroupList();
		//in
		void addGroup ( KbfxDataGroup * group );
		void setName ( TQString name ) { m_name = name;}
		void setIcon ( TQString path ) { m_iconPath = path;}
		//out
		TQString name() {return m_name;}
		GroupList getGroup() { return m_groupList;}
		TQString iconPath() { return m_iconPath;}

		int count() {return m_count;}

	private:
		TQString m_name;
		TQString m_iconPath;
		GroupList  m_groupList;
		int m_count;
};

#endif
