/*
 *   Copyright (C) 2006
 *   Siraj Razick <siraj@kdemail.net>
 *   PhobosK <phobosk@mail.kbfx.org>
 *   see Also AUTHORS
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU Library General Public License version 2 as
 *   published by the Free Software Foundation
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include "kbfxplasmapixmapprovider.h"

int
KbfxPlasmaPixmapProvider::addPixmap ( TQString pixmapname )
{
	TQString lFileName = PixmapPath( pixmapname );
	TQPixmap * lPixmapPtr = 0;

	if ( ( lPixmapPtr = TQPixmapCache::find ( pixmapname ) ) == NULL )
	{
		lPixmapPtr = new TQPixmap ( lFileName );
		TQPixmapCache::insert ( pixmapname,lPixmapPtr );
		return ( lPixmapPtr->height() *lPixmapPtr->width() *lPixmapPtr->depth() ) /8;
	}
	return 0;
}

TQString
KbfxPlasmaPixmapProvider::PixmapPath ( TQString pixmapName )
{
	TQString lFileName = ConfigInit ().m_SpinxThemeBasePath + ConfigInit ().m_SpinxThemeName + "/" + pixmapName + ".png";

	if ( TQPixmap ( lFileName ).isNull() )
		lFileName = locate ( "data", "kbfx/skins/default/" + pixmapName + ".png" );

	return lFileName;
}

TQString
KbfxPlasmaPixmapProvider::PixmapPath ( TQString pixmapName, TQString themePath,  TQString themeName )
{
	TQString lFileName = themePath + themeName + "/" + pixmapName + ".png";

	if ( TQPixmap ( lFileName ).isNull() )
		lFileName = locate ( "data", "kbfx/skins/default/" + pixmapName + ".png" );

	return lFileName;
}

bool
KbfxPlasmaPixmapProvider::PixmapPathCheck ( TQString pixmapPath )
{
	if ( TQPixmap ( pixmapPath ).isNull() )
		return FALSE;

	return TRUE;
}

void
KbfxPlasmaPixmapProvider::deletePixmap ( const TQString & key )
{
	TQPixmapCache::remove ( key );
}

void
KbfxPlasmaPixmapProvider::rebuildCache()
{
	TQPixmapCache::clear ();
	buildCache();
}

void KbfxPlasmaPixmapProvider::buildCache()
{
//m_skinElements.append("topbg");
	TQPixmapCache::setCacheLimit ( 1024*5 );
	static TQStringList  m_skinElements;
	m_skinElements
	<<"appfind"
	<<"bg"
	<<"botbg"
	<<"butterfly"
	<<"dudebox"
	<<"find"
	<<"hover"
	<<"indexseparator"
	<<"listboxbg"
	<<"lock"
	<<"lockhover"
	<<"logout"
	<<"logouthover"
	<<"mask"
	<<"menu_top"
	<<"menu_top_image_person"
	<<"middleboxbg"
	<<"normal"
	<<"off"
	<<"on"
	<<"pressed"
	<<"preview"
	<<"rhshovertile"
	<<"rhstile"
	<<"scrollnormal"
	<<"separator"
	<<"tabbg"
	<<"tilehover"
	<<"tilenormal"
	<<"topbg"
        <<"appviewbg"
	;

	for ( TQStringList::Iterator it = m_skinElements.begin(); it != m_skinElements.end(); ++it )
	{
		TQPixmapCache::setCacheLimit ( KbfxPlasmaPixmapProvider::addPixmap ( *it ) +TQPixmapCache::cacheLimit() );
	}


}

TQPixmap *
KbfxPlasmaPixmapProvider::pixmap ( const TQString & key )
{
	TQPixmap* pp;
	TQPixmap p;
	if ( ( pp=TQPixmapCache::find ( key ) ) )
	{
		return pp;
	}
	else
	{
		addPixmap ( key );
		return pixmap ( key );
	}

}

