/*
 *   Copyright (C) 2006
 *   Siraj Razick <siraj@kdemail.net>
 *   PhobosK <phobosk@mail.kbfx.org>
 *   see Also AUTHORS
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU Library General Public License version 2 as
 *   published by the Free Software Foundation
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifndef KBFX_CONFIG_H
#define KBFX_CONFIG_H

#include <config.h>

#include <tqcolor.h>
#include <tqfile.h>
#include <tqfileinfo.h>
#include <tqfont.h>
#include <tqpixmap.h>
#include <tqstring.h>

#include <kapplication.h>
#include <kconfig.h>
#include <kconfigskeleton.h>
#include <kdebug.h>
#include <kglobal.h>
#include <kiconloader.h>
#include <klocale.h>
#include <kstandarddirs.h>
#include <kuser.h>

#include <kbfxplasmapixmapprovider.h>

class KbfxConfig
{
	public:
		void read();
		void readFontrc ( TQString &themePath, TQString &themeName, bool user_rc=TRUE );
		void readThemerc ( TQString &themePath, TQString &themeName, bool user_rc=TRUE );
		void readThemeInfo ( TQString &themePath, TQString &themeName );
		void setDefault();
		void setThemeDefault();
		void setFontsDefault();
		void setThemeInfoDefault();
		void write();
		void writeFontrc ( TQString &themeName );
		void writeThemerc ( TQString &themeName );
		void checkValues();

		/* Theme info resources */
		TQString m_InfoVersion;
		TQString m_InfoVersionDefault;
		TQString m_InfoAuthor;
		TQString m_InfoAuthorDefault;
		TQString m_InfoEmail;
		TQString m_InfoEmailDefault;
		TQString m_InfoUrl;
		TQString m_InfoUrlDefault;

		/* kbfx_menu_button config items list */
		TQString m_KbfxThemesVersion;
		TQString KbfxThemeRcDestination;
		TQString KbfxRcPath;
		TQPixmap KbfxOnImg;
		TQPixmap KbfxOffImg;
		int m_KbfxGeneralVersion;
		int m_KbfxGeneralVersionDefault;
		TQString m_KbfxNormalButtonPath;
		TQString m_KbfxNormalButtonPathDefault;
		TQString m_KbfxHoverButtonPath;
		TQString m_KbfxHoverButtonPathDefault;
		TQString m_KbfxPressedButtonPath;
		TQString m_KbfxPressedButtonPathDefault;
		TQString m_KbfxMouseOverAnimationPath;
		TQString m_KbfxMouseOverAnimationPathDefault;
		TQColor m_KbfxButtonColor;
		TQColor m_KbfxButtonColorDefault;
		int m_KbfxButtonSize;
		int m_KbfxButtonSizeDefault;
		bool m_KbfxButtonGlow;
		bool m_KbfxButtonGlowDefault;
		bool m_KbfxButtonKikerResize;
		bool m_KbfxButtonKikerResizeDefault;
		TQString m_KbfxMenuType;
		TQString m_KbfxMenuTypeDefault;

		/* spinx config items list */
		TQString m_SpinxThemeBasePath;
		TQString m_SpinxThemeBasePathDefault;
		TQString m_UserSpinxThemeBasePath;
		TQString m_UserSpinxThemeBasePathDefault;
		bool m_SpinxDudeBlink;
		bool m_SpinxDudeBlinkDefault;
		TQString m_SpinxDudeImage;
		TQString m_SpinxDudeImageDefault;
		TQString m_SpinxThemeName;
		TQString m_SpinxThemeNameDefault;
		bool m_ToolBarResize;
		bool m_ToolBarResizeDefault;
		bool m_KbfxWatcher;
		bool m_KbfxWatcherDefault;
		bool m_KbfxShowOldThemes;
		bool m_KbfxShowOldThemesDefault;


		/* tooltip options list */
		bool m_ToolTipAnimation;
		bool m_ToolTipAnimationDefault;
		bool m_ToolTip;
		bool m_ToolTipDefault;
		TQString m_ToolTipText;
		TQString m_ToolTipTextDefault;
		TQString m_ToolTipAvatar;
		TQString m_ToolTipAvatarDefault;
		TQString m_SpinxTooltipDudebox;
		TQString m_SpinxTooltipDudeboxDefault;
		TQString m_SpinxTooltipMask;
		TQString m_SpinxTooltipMaskDefault;
		TQString m_SpinxTooltipWindow;
		TQString m_SpinxTooltipWindowDefault;
		TQString m_SpinxTooltipLogo;
		TQString m_SpinxTooltipLogoDefault;

		TQString m_KbfxHistory;
		TQString m_KbfxHistoryDefault;

		/* font settings */
		TQColor m_fontTooltipColor;
		TQColor m_fontTooltipColorDefault;
		TQFont m_fontTooltipFont;
		TQFont m_fontTooltipFontDefault;
		TQColor m_fontAppNameColor;
		TQColor m_fontAppNameColorDefault;
		TQFont m_fontAppNameFont;
		TQFont m_fontAppNameFontDefault;
		TQColor m_fontAppCommentColor;
		TQColor m_fontAppCommentColorDefault;
		TQFont m_fontAppCommentFont;
		TQFont m_fontAppCommentFontDefault;
		TQColor m_lineColor;
		TQColor m_lineColorDefault;
		TQColor m_fontIndexColor;
		TQColor m_fontIndexColorDefault;
		TQFont m_fontIndexFont;
		TQFont m_fontIndexFontDefault;
		TQColor m_userImageColor;
		TQColor m_userImageColorDefault;
		TQColor m_userNameColor;
		TQColor m_userNameColorDefault;
		TQFont m_userNameFont;
		TQFont m_userNameFontDefault;
		TQColor m_sepNameColor;
		TQColor m_sepNameColorDefault;
		TQFont m_sepNameFont;
		TQFont m_sepNameFontDefault;
		TQColor m_pluginNameColor;
		TQColor m_pluginNameColorDefault;
		TQFont m_pluginNameFont;
		TQFont m_pluginNameFontDefault;
		bool m_fontHoverBold;
		bool m_fontHoverBoldDefault;

		/* history */
		TQStringList m_pluginsLeft;
		TQStringList m_pluginsLeftDefault;
		TQStringList m_pluginsRight;
		TQStringList m_pluginsRightDefault;

		/* layout */
		int m_facePos_x;
		int m_facePos_xDefault;
		int m_facePos_y;
		int m_facePos_yDefault;
		int m_userNamePos_x;
		int m_userNamePos_xDefault;
		int m_userNamePos_y;
		int m_userNamePos_yDefault;
		bool m_faceBoxHideText;
		bool m_faceBoxHideTextDefault;
		int m_userMenuHeight;
		int m_userMenuHeightDefault;
		int m_userMenuWidth;
		int m_userMenuWidthDefault;

		int m_topBar_x;
		int m_topBar_xDefault;
		int m_topBar_y;
		int m_topBar_yDefault;
		int m_topBar_h;
		int m_topBar_hDefault;
		int m_topBar_w;
		int m_topBar_wDefault;

		int m_botBar_x;
		int m_botBar_xDefault;
		int m_botBar_y;
		int m_botBar_yDefault;
		int m_botBar_h;
		int m_botBar_hDefault;
		int m_botBar_w;
		int m_botBar_wDefault;

		int m_scrollBarTopX;
		int m_scrollBarTopXDefault;
		int m_scrollBarTopY;
		int m_scrollBarTopYDefault;
		int m_scrollBarBotX;
		int m_scrollBarBotXDefault;
		int m_scrollBarBotY;
		int m_scrollBarBotYDefault;

		int m_listBox_x;
		int m_listBox_xDefault;
		int m_listBox_y;
		int m_listBox_yDefault;
		int m_listBox_w;
		int m_listBox_wDefault;
		int m_listBox_h;
		int m_listBox_hDefault;

		int m_searchBox_x;
		int m_searchBox_xDefault;
		int m_searchBox_y;
		int m_searchBox_yDefault;
		int m_searchBox_w;
		int m_searchBox_wDefault;
		int m_searchBox_h;
		int m_searchBox_hDefault;
		bool m_searchBox_static;
		bool m_searchBox_staticDefault;

		int m_itemView_x;
		int m_itemView_xDefault;
		int m_itemView_y;
		int m_itemView_yDefault;
		int m_itemView_h;
		int m_itemView_hDefault;
		int m_itemView_w;
		int m_itemView_wDefault;

		int m_fadeTime;
		int m_fadeTimeDefault;

		/* toolbar */
		int m_toolBarButtonNormalSizeDefault;
		int m_toolBarButtonNormalSize;
		int m_toolBarButtonExpandSizeDefault;
		int m_toolBarButtonExpandSize;

		/* Face Icon */
		int m_faceIconX;
		int m_faceIconXDefault;
		int m_faceIconY;
		int m_faceIconYDefault;
		int m_faceIconH;
		int m_faceIconHDefault;
		int m_faceIconW;
		int m_faceIconWDefault;

		/* element controll */
		int m_iconSize;
		int m_iconSizeDefault;
		bool m_noComments;
		bool m_noCommentsDefault;
		int m_commentMargine;
		int m_commentMargineDefault;
		/* states */
		bool m_startHidden;
		bool m_startHiddenDefault;

		bool m_KbfxDeleteOldConf;

	private:
		KbfxConfig();
		KbfxConfig ( const KbfxConfig& );

		friend KbfxConfig& ConfigInit();
};

KbfxConfig & ConfigInit();

#endif

