#################################################
#
#  (C) 2011 Timothy Pearson
#  kb9vqf (AT) pearsoncomputing.net
#
#  Improvements and feedback are welcome
#
#  This file is released under GPL >= 2
#
#################################################

if( BUILD_TRANSLATIONS AND NOT DEFINED MSGFMT_EXECUTABLE )
  find_program( MSGFMT_EXECUTABLE msgfmt )
  if( NOT MSGFMT_EXECUTABLE )
    tde_message_fatal( "msgfmt program is required, but was not found on your system" )
  endif( )
endif( )

check_type_size( "int" SIZEOF_INT BUILTIN_TYPES_ONLY )
check_type_size( "long" SIZEOF_LONG BUILTIN_TYPES_ONLY )

check_include_file( stdint.h HAVE_STDINT_H )
check_include_file( systems.h HAVE_SYSTEMS_H )
check_include_file( linux/inotify.h HAVE_INOTIFY )

check_function_exists( statvfs HAVE_STATVFS )


#### Find strigi if needed #######################

IF (USE_STRIGI)
	FIND_PACKAGE(Strigi REQUIRED)
	INCLUDE_DIRECTORIES(${STRIGI_INCLUDE_DIR})
	MESSAGE(STATUS "Strigi support is: ON!")
ELSE (USE_STRIGI)
	MESSAGE(STATUS "Strigi support is: OFF!")
ENDIF (USE_STRIGI)

# common required stuff
find_package( TQt )
find_package( TDE )


#### Find menudrake if needed #####################

FIND_PROGRAM(HAVE_MANDRAKE menudrake)
IF (HAVE_MANDRAKE AND USE_MENUDRAKE)
	SET(MANDRAKE "1")
	MESSAGE(STATUS "Will use 'menudrake' instead of 'kmenuedit'!")
ELSE (HAVE_MANDRAKE AND USE_MENUDRAKE)
	SET(MANDRAKE "")
	MESSAGE(STATUS "Will use 'kmenuedit'!")
ENDIF (HAVE_MANDRAKE AND USE_MENUDRAKE)