/***************************************************************************
                          tokendialog.h  -  description
                             -------------------
    begin                : Sat Oct 23 2004
    copyright            : (C) 2004 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef TOKENDIALOG_H
#define TOKENDIALOG_H

#include <kwizard.h>
#include "documentitem.h"
#include "tokenprovider.h"

class KListBox;
class KListView;
class TQListBoxItem;
class TQListViewItem;
class KLineEdit;
class TokenProvider;

class TQRadioButton;
class TQWidgetStack;
class TQHBox;
class KComboBox;
class TQTextBrowser;
class KPushButton;
class DSTextEdit;

class TokenDialog : public KWizard {
    
 Q_OBJECT
  TQ_OBJECT

 public:
    TokenDialog( TokenProvider* token, TQWidget *parent = 0, const char *name = 0 );
   
    inline const TQString & token() const { return m_result; }

 private slots:
    void categoryChanged( TQListBoxItem* item );
    void itemChanged( TQListViewItem* item );

 private:
    void initAll();
    void initStackPage2();

    void setupPage1();
    void setupPage2();
    void setupPage3();

    void setupStackPage1();
    void setupStackPage2();

    void setupStack2Page1();
    void setupStack2Page2();
    void setupStack2Page3();
    void setupStack2Page4();
    void setupStack2Page5();

 private slots:
     void enableControls();
     void testQuery();

 protected:
    void accept();
    void showPage( TQWidget* w );

 private:
    TQStringList m_custom_tokens;

    TQRadioButton* radioAll;
    TQRadioButton* radioLabel;
    TQRadioButton* radioSQL;
    TQRadioButton* radioDate;
    TQRadioButton* radioFixed;
    TQRadioButton* radioCustom;
    TQRadioButton* radioAddress;

    TQRadioButton* radioSQLQuery;
    TQRadioButton* radioVariable;
    TQRadioButton* radioJavaScript;

    TQRadioButton* radioVariableNew;
    TQRadioButton* radioVariableExisting;
    
    KLineEdit* editVariable;
    KListBox* listVariable;

    KLineEdit* editQuery;
    TQTextBrowser* textQueryResults;
    KPushButton* buttonQuery;

    DSTextEdit* editJavaScript;

    TQString m_result;

    TQWidgetStack* page2;
    TQWidgetStack* page3;

    TQWidget* stackPage1;
    TQWidget* stackPage2;

    TQWidget* stack2Page1;
    TQWidget* stack2Page2;
    TQWidget* stack2Page3;
    TQWidget* stack2Page4;
    TQWidget* stack2Page5;

    TQValueList<tToken> m_tokens;
    TokenProvider* m_token;

    KListBox* category;
    KListView* allList;
    KLineEdit* lineEdit;

    KListView* labelList;
};

#endif
