/***************************************************************************
                          mycanvasview.h  -  description
                             -------------------
    begin                : Die Apr 23 2002
    copyright            : (C) 2002 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef MYCANVASVIEW_H
#define MYCANVASVIEW_H

#include <tqcanvas.h>
#include <tqvaluelist.h>
#include "documentitem.h"

class TCanvasItem;

typedef TQValueList<TCanvasItem*> TCanvasItemList;


class TQRect;
class TQPainter;
class MyCanvas : public TQCanvas {
    Q_OBJECT
  TQ_OBJECT

    public:
        MyCanvas( TQObject* parent, const char* name = 0 );
        ~MyCanvas();

        void setRect( TQRect r ) {
            m_rect = r;
        }

        TQRect rect() const {
            return m_rect;
        }

        void setGrid( bool enabled ) {
                m_grid = enabled;
        }

        bool grid() const { return m_grid; }

    protected:
        void drawBackground( TQPainter & painter, const TQRect & clip );

    private:
        TQRect m_rect;
        bool m_grid;
};

class Definition;
class TQColor;
class TQLabel;
class TQPoint;
class KCommandHistory;
class KMacroCommand;
class KRuler;
class KStatusBar;
class MyCanvasView : public TQCanvasView
{
    Q_OBJECT
  TQ_OBJECT

    enum edges {
        TopLeft,
        TopMiddle,
        TopRight,
        RightMiddle,
        LeftMiddle,
        BottomLeft,
        BottomMiddle,
        BottomRight,
        Inside,
        Outside,
        Barcode
    };
    
    public:
        MyCanvasView( Definition* d, MyCanvas *c, TQWidget* parent=0, const char* name=0, WFlags f=0);
        ~MyCanvasView();

	/** return a list of all DocumentItems on the canvas
	 */
	DocumentItemList getAllItems();

        TCanvasItemList getSelected();

        TCanvasItem* getActive();
        void setActive( TQCanvasItem* item = 0, bool control = false );

        void setCurrent( TQCanvasItem* item );

        void setHistory( KCommandHistory* hist ) {
            history = hist;
        }

        TQPoint getTranslation() const {
            return translation;
        }

        void setDefinition( Definition* d );
        void setPosLabel( KStatusBar* s, int id ) {
            mouseid = id;
            statusbar = s;
        }

        static int getLowestZ( TQCanvasItemList list );
        static int getHighestZ( TQCanvasItemList list );
        
        void snapPoint(TQPoint* point, TCanvasItem* item) ;
        
    public slots:
        void selectAll();
        void deSelectAll();
        
        void deleteCurrent();

        void updateGUI() {
            canvas()->update();
            repaintContents();
        }

    protected:
        void contentsMousePressEvent(TQMouseEvent*);
        void contentsMouseMoveEvent(TQMouseEvent*);
        void contentsMouseReleaseEvent(TQMouseEvent *);
        void contentsMouseDoubleClickEvent(TQMouseEvent*);
        void resizeEvent( TQResizeEvent * r );
        
    signals:
        void selectionChanged();
        void movedSomething();
        void doubleClickedItem( TCanvasItem* );
        void showContextMenu( TQPoint );
        
    private:
        void setSelected( TQCanvasItem* item = 0, bool control = false );
        KMacroCommand* getMoveCommand();
        
        Definition* def;

        KRuler* rulerv;
        KRuler* rulerh;

        KCommandHistory* history;
        KMacroCommand* m_commov;
        MyCanvas* canv;

        int mouseid;
        KStatusBar* statusbar;

        TQPoint moving_start;
        TQPoint translation;

        TQRect old;

        bool isInside( TQPoint p, TQCanvasItem* item );
        int isEdge(  TQPoint p, TQCanvasItem* item  );
        void reposition();
        void updateRuler();
        int updateCursor( TQPoint pos, bool pressed = false );
        int m_mode;
        TQPoint delta_pt ;
};

#endif
