/***************************************************************************
                          labeleditor.h  -  description
                             -------------------
    begin                : Die Apr 23 2002
    copyright            : (C) 2002 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef LABELEDITOR_H
#define LABELEDITOR_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "sqltables.h"
#include "labelutils.h"
#include "definition.h"
#include "dsmainwindow.h"
#include "xmlutils.h"
#include "editoriface.h"

#include <kdialogbase.h>
#include <tqdialog.h>
#include <tqmap.h>

class BatchPrinter;
class KURL;
class KAction;
class KActionMenu;
class KActionSeparator;
class KToggleAction;
class KRecentFilesAction;
class KToolBarPopupAction;
class KListBox;
class KMenuBar;
class KPopupMenu;
class KRuler;
class KToolBar;
class KCommandHistory;
class MyCanvasText;
class MyCanvasRectangle;
class MyCanvasView;
class BarcodeItem;
class MyCanvas;
class TQCanvasItemList;
class TQCheckBox;
class KComboBox;
class TQDockArea;
class TQDockWindow;
class TQGroupBox;
class TQLabel;
class TQImage;
class TQHBoxLayout;
class TQVBoxLayout;
class TQPoint;
class TQRect;
class TQPaintDevice;
class TQString;
class KPushButton;
class KPrinter;
class TQCanvasItem;
class TCanvasItem;
class RectItem;
class LineItem;

class TokenProvider;
/** The LabelEditor is a graphical, easy to use label designer.
  * It provides all the function necessary to create colorful labels
  * and save them. Labels can also be printed directly, but without database
  * support. Use Batchprinting (LabelPrinter) for this.
  */
class LabelEditor : public DSMainWindow, public EditorIface, private LabelUtils, private XMLUtils {
    Q_OBJECT
  TQ_OBJECT
    public:
        enum ELabelEditorMode {
            eCreateNewLabel,
            eLoadLabel
        };

        LabelEditor( TQWidget *parent=0, TQString _filename = TQString(),
            const char *name="labeleditor", WFlags f = WType_TopLevel | WDestructiveClose );
        ~LabelEditor();
        bool startupDlg( ELabelEditorMode mode, TQString f = TQString() );

        /**
          * returns the filename of the currently loaded label.
          */
        const TQString fileName() const;
        
    public slots:
        void print();
        void printBCP();
        void printImage();
        
    private:

	/** Creates a KCommandHistory object which will be 
	 *  pointed to by history.
	 *  Make sure to delete history by yourself when needed.
	 */
	void createCommandHistory();
	/** Create undo and redo actions and plug them into
	 *  menus and toolbars. They have to be regenerated
	 *  when ever createCommandHistory was called.
	 */
	void createCommandHistoryActions();

        TQString getCustomerName( int mode = 0, TQString text = "" );
        void clearLabel();
        //void setupBarcode( BarcodeItem* bcode );
        void insertText( TQString caption );
        //NY35
        void insertTextLine( TQString caption );
        //NY35
        void setupActions();
        void enableActions();
        bool isChanged();   // if the current document has been changed
        void batchPrint( BatchPrinter* batch, int copies, int mode );
        void setupContextMenu();
        
    private slots:
        void startEditor();
        bool open();
        bool openUrl( const TQString & url );
        bool save();
        bool saveas();
        bool save( TQString url );
        void save( TQIODevice* device );
        bool newLabel();
        void insertBarcode();
        void insertPicture();
        void insertText();
        void insertDataText();
        //NY36
        void insertTextLine();
        //NY36
        void insertRect();
        void insertCircle();
        void insertLine();

        void changeDes();
        void changeSize();
        void updateInfo();
        void doubleClickedItem( TCanvasItem* item );
        void showContextMenu( TQPoint pos );
        void doubleClickedCurrent();
        void spellCheck();
        void centerVertical();
        void centerHorizontal();
        void raiseCurrent();
        void lowerCurrent();
        void onTopCurrent();
        void backCurrent();
        void preview();
        void toggleGrid();
        void cut();
        void copy();
        void paste();
        void startBarcodeGen();
        void saveConfig();
        void loadConfig();
        void startLoadRecentEditor( const KURL& url );
        void startLoadEditor();
        void batchPrint();
        void closeLabel();
        void setEdited();
        void launchAddressBook();
        void lockItem();
        
    protected:
        void closeEvent( TQCloseEvent* e );

        KCommandHistory* history;

        KAction* saveAct;
        KAction* saveAsAct;
        KAction* exportAct;
        KAction* descriptionAct;
        KAction* printAct;
        KAction* bcpAct;
        KAction* imgAct;
        KAction* changeSizeAct;
        KAction* deleteAct;
        KAction* editPropAct;
        KAction* barcodeAct;
        KAction* rectAct;
        KAction* circleAct;
        KAction* lineAct;
        KAction* pictureAct;
        KAction* previewAct;
        KAction* textAct;
        KAction* textDataAct;
        KAction* textLineAct;
        KAction* spellAct;
        KAction* cutAct;
        KAction* copyAct;
        KAction* pasteAct;
        KAction* undoAct;
        KAction* redoAct;
        KAction* closeLabelAct;
        KAction* addressBookAct;
        KAction* selectAllAct;
        KAction* deSelectAllAct;

	/**
	 * Undo/Redo actins get pluged into this menu
	 */
	KPopupMenu* editMenu;        
        KPopupMenu* exportMenu;        
        KPopupMenu* m_mnuContext;
        
        KToolBar* tools;
        
        KToggleAction* gridAct;
        
        KComboBox* comboScale;

        KRecentFilesAction* recentAct;
        KActionSeparator* sep;
        KToolBarPopupAction* listAct;
        MyCanvas* c;
        MyCanvasView* cv;

        Definition* d;
	TokenProvider* m_token;

        // Label info's:
        TQString description;    // description
        TQString filename;       // current file

        KListBox* listFields;
        KPushButton* buttonText;

        TQVBoxLayout* pageLayout;

        TQMap<TQString,TQString> fields;

        bool m_edited;
};

#endif
