/*
 * Copyright (C) 2003 Dominik Seichter <domseichter@web.de>
 */

#include "kfile_kbarcode.h"

#include <kgenericfactory.h>
#include <klocale.h>

#include <tqfile.h>
#include <tqdom.h>

K_EXPORT_COMPONENT_FACTORY(kfile_kbarcode, KGenericFactory<KBarcodePlugin>( "kfile_kbarcode" ));

KBarcodePlugin::KBarcodePlugin(TQObject *parent, const char *name,
                       const TQStringList &args)

    : KFilePlugin(parent, name, args)
{
    KFileMimeTypeInfo* info = addMimeTypeInfo( "application/kbarcode-label" );

    KFileMimeTypeInfo::GroupInfo* group = 0L;

    group = addGroupInfo(info, "Label", i18n("Label"));

    KFileMimeTypeInfo::ItemInfo* item;

    item = addItemInfo(group, "Manufacturer", i18n("Manufacturer"), TQVariant::String );
    item = addItemInfo(group, "Type", i18n("Type"), TQVariant::String);
    item = addItemInfo(group, "Description", i18n("Description"), TQVariant::String );
    item = addItemInfo(group, "Id", i18n("Label Id"), TQVariant::String );
    item = addItemInfo(group, "Dimensions", i18n("Dimensions"), TQVariant::Size);
    setHint( item, KFileMimeTypeInfo::Size );
    setUnit(item, KFileMimeTypeInfo::Centimeters );
}


bool KBarcodePlugin::readInfo( KFileMetaInfo& info, uint )
{
    TQFile f( info.path() );
    if ( !f.open( IO_ReadOnly ) )
        return false;

    TQDomDocument doc( "KBarcodeLabel" );
    if ( !doc.setContent( &f ) ) {
        f.close();
        return false;
    }

    KFileMetaInfoGroup group = appendGroup(info, "Label");

    TQDomNode n = doc.documentElement().firstChild();
    while( !n.isNull() ) {
        TQDomElement e = n.toElement(); // try to convert the node to an element.
        if( !e.isNull() )
            if( e.tagName() == "label" ) {
                TQDomNode node = e.firstChild();
                while( !node.isNull() ) {
                    TQDomElement e = node.toElement(); // try to convert the node to an element.
                    if( !e.isNull() )
                        if( e.tagName() == "description" )
                            appendItem(group, "Description", e.text() );
                        else if( e.tagName() == "id" ) {
                            appendItem(group, "Manufacturer", e.attribute("producer", "") );
                            appendItem(group, "Type", e.attribute("type", "") );
                            appendItem(group, "Id", e.text() );
                            appendItem(group, "Dimensions",
                                TQSize( int(e.attribute("width", "0").toDouble()/10), int(e.attribute("height", "0").toDouble()/10) ) );
                        }

                    node = node.nextSibling();
                }
                n = n.nextSibling();
            }

        n = n.nextSibling();
    }


    f.close();
    return true;
}

#include "kfile_kbarcode.moc"
