/***************************************************************************
 *   Copyright (C) 2005 by Bastian Holst                                   *
 *   bastianholst@gmx.de                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
#ifndef SONG_H
#define SONG_H

#include "katapultitem.h"
#include "coverimage.h"
#include <kurl.h>
#include <tqstring.h>
#include <tqpixmap.h>

/**
@author Bastian Holst
*/
class Song : public KatapultItem
{
	Q_OBJECT
  TQ_OBJECT
public:
	Song(const TQString&);
	
	virtual TQPixmap icon(int) const;
	virtual TQString text() const;
	virtual KURL url() const;
	
	void setArtist(const TQString&);
	void setName(const TQString&);
	void setURL(const KURL);
	void setIcon(const TQString);
	void setAlbum(const TQString&);
	
protected:
	TQString _artist;
	TQString _name;
	KURL _url;
	
	CoverImage cover;
};

#endif //SONG_H
