/***************************************************************************
 *   Copyright (C) 2005 by Bastian Holst                                   *
 *   bastianholst@gmx.de                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
 
#include <kglobal.h>
#include <kiconloader.h> 
#include <kurl.h>
#include <tqpixmap.h>
#include <tqimage.h>
#include <tqstring.h>
#include <amarokcatalog.h>

#include "song.h"

Song::Song(const TQString&)
	: KatapultItem()
{
	setName(TQString());
	setArtist(TQString());
	setURL(KURL());
	setIcon(TQString());
	setAlbum(TQString());
}

void Song::setArtist(const TQString& artist)
{
	_artist = artist;
	cover.setArtist(artist);
}

void Song::setName(const TQString& name)
{
	_name = name;
}

void Song::setAlbum(const TQString& album)
{
	cover.setAlbum(album);
}

void Song::setURL(const KURL url)
{
	_url = url;
}

void Song::setIcon(const TQString icon)
{
	cover.setURL(icon);
}

TQPixmap Song::icon(int size) const
{
	TQImage image = cover.load(size);
	if ( image.isNull() )
		return KGlobal::iconLoader()->loadIcon("multimedia", KIcon::NoGroup, size);
	return TQPixmap(image);
}

TQString Song::text() const
{
	TQString text;
	if( !_artist.isEmpty() ) {
		text.append(_artist);
		text.append(": ");
	}
	text.append(_name);
	return text;
}

KURL Song::url() const
{
	return _url;
}

#include "song.moc"
