/***************************************************************************
 *   Copyright (C) 2005 by Joe Ferris                                      *
 *   jferris@optimistictech.com                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
#ifndef KATAPULTDISPLAY_H
#define KATAPULTDISPLAY_H

#include <tqwidget.h>
#include <tqstring.h>
#include <tqevent.h>

#include "katapultitem.h"
#include "katapultaction.h"

class Katapult;
class KConfigBase;

/**
@author Joe Ferris
*/
class KatapultDisplay : public TQWidget
{
	Q_OBJECT
  TQ_OBJECT

public:
	KatapultDisplay(const char *, WFlags);
	virtual ~KatapultDisplay();
	
	void setQuery(TQString);
	void setSelected(unsigned int);
	void setItem(const KatapultItem *);
	void setAction(const KatapultAction *);
	void setStatus(int);

	virtual void readSettings(KConfigBase *);
	virtual void writeSettings(KConfigBase *);
	virtual TQWidget * configure();
	
signals:
	void keyReleased(TQKeyEvent *);
	void focusOut();
	
protected:
	virtual void keyPressEvent(TQKeyEvent *);
	virtual void keyReleaseEvent(TQKeyEvent *);
	virtual void focusOutEvent(TQFocusEvent *);
	
	TQString query() const;
	unsigned int selected() const;
	const KatapultItem * item() const;
	const KatapultAction * action() const;
	int status() const;
	
private:
	TQString _query;
	unsigned int _selectionLength;
	const KatapultItem *_item;
	const KatapultAction *_action;
	int _status;
	Katapult *app;
};

#endif
