/***************************************************************************
 *   Copyright (C) 2005 by Joe Ferris                                      *
 *   jferris@optimistictech.com                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
#ifndef IMAGEDISPLAY_H
#define IMAGEDISPLAY_H

#include <tqevent.h>
#include <tqpixmap.h>
#include <tqtimer.h>
#include <tqimage.h>

#include "katapultdisplay.h"

class Katapult;
class TQFont;

/**
@author Joe Ferris, Bastian Holst
*/
class ImageDisplay : public KatapultDisplay
{
	Q_OBJECT
  TQ_OBJECT
public:
	ImageDisplay(TQObject *, const char *, const TQStringList&);
	virtual ~ImageDisplay();
	
public slots:
	void continueFade();
	virtual void hide();

	virtual void readSettings(KConfigBase *);
	virtual void writeSettings(KConfigBase *);
	virtual TQWidget * configure();
	
	void setFont(const TQString &);
	void setMinFontSize(int);
	void setMaxFontSize(int);
	void setFadeOut(int);
	void updateFadeStep();
	
protected:
	virtual void showEvent(TQShowEvent *);
	virtual void paintEvent(TQPaintEvent *);

	void setSingleBG(TQPixmap *);
	void setDoubleBG(TQPixmap *);
	void setSingleSize(int width, int height);
	void setDoubleSize(int width, int heught);
	void setMargin(int left, int top, int right, int bottom);
	void setPadding(int);
	void setIconSize(int);
	
	TQPixmap getDisplay();
	void drawText(TQPixmap &, int, int, TQString, int) const;
	void placeWindow(int);
    
private:
	void updateOffset();
	
	TQPixmap *bgSngl, *bgDbl, *singlebg, *doublebg;
	TQRect desktopSize;
	TQImage *fadeImg;
	TQTimer *fadeTimer;
	TQString fontFace;
	int minFontSize, maxFontSize;
	int alpha;
	bool fadeOut;
	int fadeTime, fadeStep;
	int displaySize;
	// 0: left, 1: top, 2: right, 3: bottom
	int margin[4];
	int offset[4];
	// 0: width, 1: height
	int singlesize[2];
	int doublesize[2];
	int padding;
	int iconsize;
};

#endif
