/*
 * videosettings.h
 *
 * Copyright (C) 2003-2005 Jürgen Kofler <kaffeine@gmx.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 */

#ifndef VIDEOSETTINGS_H
#define VIDEOSETTINGS_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kdialogbase.h>

class TQSlider;

class VideoSettings : public KDialogBase
{

   Q_OBJECT
  TQ_OBJECT
   
public: 
  VideoSettings(int hue, int sat, int contrast, int bright, int avOffset,
                int spuOffset, TQWidget *parent=0, const char *name=0);
 ~VideoSettings();

signals:
  void signalNewHue(int);
  void signalNewSaturation(int);
  void signalNewContrast(int);
  void signalNewBrightness(int);
  void signalNewAVOffset(int);
  void signalNewSpuOffset(int);

private slots:

  void slotSetDefaultValues();


private:
  TQSlider* m_hueSlider;
  TQSlider* m_satSlider;
  TQSlider* m_contrastSlider;
  TQSlider* m_brightSlider;
  TQSlider* m_avOffsetSlider;
  TQSlider* m_spuOffsetSlider;
                
};

#endif /* VIDEOSETTINGS_H */
